<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemarkType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplementary information.
 * @subpackage Structs
 */
class RemarkType extends AbstractStructBase
{
    /**
     * The DisplayInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, this remark should be displayed. Notes: 1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by
     * this specification. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DisplayInd;
    /**
     * The RemarkText
     * Meta information extracted from the WSDL
     * - documentation: Additional, supplementary information about the document or service. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemarkText;
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - documentation: Remark creation timestamp. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Timestamp;
    /**
     * Constructor method for RemarkType
     * @uses RemarkType::setDisplayInd()
     * @uses RemarkType::setRemarkText()
     * @uses RemarkType::setTimestamp()
     * @param bool $displayInd
     * @param string $remarkText
     * @param string $timestamp
     */
    public function __construct($displayInd = null, $remarkText = null, $timestamp = null)
    {
        $this
            ->setDisplayInd($displayInd)
            ->setRemarkText($remarkText)
            ->setTimestamp($timestamp);
    }
    /**
     * Get DisplayInd value
     * @return bool|null
     */
    public function getDisplayInd()
    {
        return $this->DisplayInd;
    }
    /**
     * Set DisplayInd value
     * @param bool $displayInd
     * @return \StructType\RemarkType
     */
    public function setDisplayInd($displayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayInd) && !is_bool($displayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayInd, true), gettype($displayInd)), __LINE__);
        }
        $this->DisplayInd = $displayInd;
        return $this;
    }
    /**
     * Get RemarkText value
     * @return string|null
     */
    public function getRemarkText()
    {
        return $this->RemarkText;
    }
    /**
     * Set RemarkText value
     * @param string $remarkText
     * @return \StructType\RemarkType
     */
    public function setRemarkText($remarkText = null)
    {
        // validation for constraint: string
        if (!is_null($remarkText) && !is_string($remarkText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarkText, true), gettype($remarkText)), __LINE__);
        }
        $this->RemarkText = $remarkText;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\RemarkType
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
}
