<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundMethodCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information relating to refund preference. This could relate to the seller or the customer depending on the preference expressed within the container.
 * @subpackage Structs
 */
class RefundMethodCriteriaType extends AbstractStructBase
{
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Type code assigned according to ATS Codeset PAYT. Example VI for Visa Card | The form of payment type. Examples: Credit Card, Cash. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Form of payment
     * identification{/codeListName} {codeListIdentifier}9888{/codeListIdentifier} | Additional BDT to specify payment method code.
     * - base: PaymentMethodCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The OriginalPaymentMethodInd
     * Meta information extracted from the WSDL
     * - documentation: An Indicator for a Original Payment Method | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $OriginalPaymentMethodInd;
    /**
     * The PaymentBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Brand code assigned according to ATS Codeset PAYB. Example CC for Customer Card | ENUM to specify the CC vendor code in case FOID is a Credit Card (e.g. VI, MC, etc). | Additional BDT to specify the CC vendor code in case
     * FOID is a Credit Card.
     * - base: CreditCardVendorCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9a-zA-Z]{1,2}
     * @var string
     */
    public $PaymentBrandCode;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - documentation: A specialization of Payment Card used for refund criteria, defined as a device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RefundPaymentCardType
     */
    public $PaymentCard;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * Constructor method for RefundMethodCriteriaType
     * @uses RefundMethodCriteriaType::setPaymentTypeCode()
     * @uses RefundMethodCriteriaType::setOriginalPaymentMethodInd()
     * @uses RefundMethodCriteriaType::setPaymentBrandCode()
     * @uses RefundMethodCriteriaType::setPaymentCard()
     * @uses RefundMethodCriteriaType::setPrefLevel()
     * @param string $paymentTypeCode
     * @param bool $originalPaymentMethodInd
     * @param string $paymentBrandCode
     * @param \StructType\RefundPaymentCardType $paymentCard
     * @param \StructType\PrefLevelType $prefLevel
     */
    public function __construct($paymentTypeCode = null, $originalPaymentMethodInd = null, $paymentBrandCode = null, \StructType\RefundPaymentCardType $paymentCard = null, \StructType\PrefLevelType $prefLevel = null)
    {
        $this
            ->setPaymentTypeCode($paymentTypeCode)
            ->setOriginalPaymentMethodInd($originalPaymentMethodInd)
            ->setPaymentBrandCode($paymentBrandCode)
            ->setPaymentCard($paymentCard)
            ->setPrefLevel($prefLevel);
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\RefundMethodCriteriaType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get OriginalPaymentMethodInd value
     * @return bool|null
     */
    public function getOriginalPaymentMethodInd()
    {
        return $this->OriginalPaymentMethodInd;
    }
    /**
     * Set OriginalPaymentMethodInd value
     * @param bool $originalPaymentMethodInd
     * @return \StructType\RefundMethodCriteriaType
     */
    public function setOriginalPaymentMethodInd($originalPaymentMethodInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($originalPaymentMethodInd) && !is_bool($originalPaymentMethodInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($originalPaymentMethodInd, true), gettype($originalPaymentMethodInd)), __LINE__);
        }
        $this->OriginalPaymentMethodInd = $originalPaymentMethodInd;
        return $this;
    }
    /**
     * Get PaymentBrandCode value
     * @return string|null
     */
    public function getPaymentBrandCode()
    {
        return $this->PaymentBrandCode;
    }
    /**
     * Set PaymentBrandCode value
     * @param string $paymentBrandCode
     * @return \StructType\RefundMethodCriteriaType
     */
    public function setPaymentBrandCode($paymentBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentBrandCode) && !is_string($paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentBrandCode, true), gettype($paymentBrandCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,2})
        if (!is_null($paymentBrandCode) && !preg_match('/[0-9a-zA-Z]{1,2}/', $paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,2}', var_export($paymentBrandCode, true)), __LINE__);
        }
        $this->PaymentBrandCode = $paymentBrandCode;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \StructType\RefundPaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \StructType\RefundPaymentCardType $paymentCard
     * @return \StructType\RefundMethodCriteriaType
     */
    public function setPaymentCard(\StructType\RefundPaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\RefundMethodCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
}
