<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefundFOP_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Refund FOP
 * @subpackage Structs
 */
class RefundFOP_Type extends AbstractStructBase
{
    /**
     * The AccountableDoc
     * Meta information extracted from the WSDL
     * - documentation: A Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AccountableDocType
     */
    public $AccountableDoc;
    /**
     * The DirectBill
     * Meta information extracted from the WSDL
     * - documentation: System in which a corporation's travel agency bills employees for their business travel. The employee must then submit an expense accounting and be reimbursed by the corporation.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DirectBillType
     */
    public $DirectBill;
    /**
     * The IATA_EasyPay
     * Meta information extracted from the WSDL
     * - documentation: Specialization for Payment Processing. IATA EasyPay is a payment instrument with a specific remittance mechanism. This FOP is not limited to BSP.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentProcessingIATA_EasyPayType
     */
    public $IATA_EasyPay;
    /**
     * The LoyaltyRedemption
     * Meta information extracted from the WSDL
     * - documentation: A form of payment by which the customer uses a virtual currency of a Loyalty Program Account (such as air miles) in exchange for goods or services.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LoyaltyRedemptionType
     */
    public $LoyaltyRedemption;
    /**
     * The OtherPaymentMethod
     * Meta information extracted from the WSDL
     * - documentation: Information relating to non-standard forms of payment which may be used in exchange for goods or services.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OtherPaymentMethodType
     */
    public $OtherPaymentMethod;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - documentation: A specialization of Payment Card for Payment Processing transactions, defined as a device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentProcessingPaymentCardType
     */
    public $PaymentCard;
    /**
     * The PaymentRedirectionResponse
     * Meta information extracted from the WSDL
     * - documentation: contains all the instructions for the Seller on how to redirect the Payer to their hosted payment page.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentRedirectionResponseType
     */
    public $PaymentRedirectionResponse;
    /**
     * The SettlementPlan
     * Meta information extracted from the WSDL
     * - documentation: Any payment that is collected by the agent and settled between the Airline and the agent. Refer to IATA Resolution 728 Attachment A for full details.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SettlementPlanType
     */
    public $SettlementPlan;
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - documentation: A document that entitles the holder to a discount or that may be exchanged for goods or services.
     * - choice: AccountableDoc | DirectBill | IATA_EasyPay | LoyaltyRedemption | OtherPaymentMethod | PaymentCard | PaymentRedirectionResponse | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VoucherType
     */
    public $Voucher;
    /**
     * Constructor method for RefundFOP_Type
     * @uses RefundFOP_Type::setAccountableDoc()
     * @uses RefundFOP_Type::setDirectBill()
     * @uses RefundFOP_Type::setIATA_EasyPay()
     * @uses RefundFOP_Type::setLoyaltyRedemption()
     * @uses RefundFOP_Type::setOtherPaymentMethod()
     * @uses RefundFOP_Type::setPaymentCard()
     * @uses RefundFOP_Type::setPaymentRedirectionResponse()
     * @uses RefundFOP_Type::setSettlementPlan()
     * @uses RefundFOP_Type::setVoucher()
     * @param \StructType\AccountableDocType $accountableDoc
     * @param \StructType\DirectBillType $directBill
     * @param \StructType\PaymentProcessingIATA_EasyPayType $iATA_EasyPay
     * @param \StructType\LoyaltyRedemptionType $loyaltyRedemption
     * @param \StructType\OtherPaymentMethodType $otherPaymentMethod
     * @param \StructType\PaymentProcessingPaymentCardType $paymentCard
     * @param \StructType\PaymentRedirectionResponseType $paymentRedirectionResponse
     * @param \StructType\SettlementPlanType $settlementPlan
     * @param \StructType\VoucherType $voucher
     */
    public function __construct(\StructType\AccountableDocType $accountableDoc = null, \StructType\DirectBillType $directBill = null, \StructType\PaymentProcessingIATA_EasyPayType $iATA_EasyPay = null, \StructType\LoyaltyRedemptionType $loyaltyRedemption = null, \StructType\OtherPaymentMethodType $otherPaymentMethod = null, \StructType\PaymentProcessingPaymentCardType $paymentCard = null, \StructType\PaymentRedirectionResponseType $paymentRedirectionResponse = null, \StructType\SettlementPlanType $settlementPlan = null, \StructType\VoucherType $voucher = null)
    {
        $this
            ->setAccountableDoc($accountableDoc)
            ->setDirectBill($directBill)
            ->setIATA_EasyPay($iATA_EasyPay)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setOtherPaymentMethod($otherPaymentMethod)
            ->setPaymentCard($paymentCard)
            ->setPaymentRedirectionResponse($paymentRedirectionResponse)
            ->setSettlementPlan($settlementPlan)
            ->setVoucher($voucher);
    }
    /**
     * Get AccountableDoc value
     * @return \StructType\AccountableDocType
     */
    public function getAccountableDoc()
    {
        return isset($this->AccountableDoc) ? $this->AccountableDoc : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccountableDoc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountableDoc method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccountableDocForChoiceConstraintsFromSetAccountableDoc($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DirectBill',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OtherPaymentMethod',
            'PaymentCard',
            'PaymentRedirectionResponse',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountableDoc can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountableDoc, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AccountableDoc value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountableDocType $accountableDoc
     * @return \StructType\RefundFOP_Type
     */
    public function setAccountableDoc(\StructType\AccountableDocType $accountableDoc = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($accountableDocChoiceErrorMessage = self::validateAccountableDocForChoiceConstraintsFromSetAccountableDoc($accountableDoc))) {
            throw new \InvalidArgumentException($accountableDocChoiceErrorMessage, __LINE__);
        }
        if (is_null($accountableDoc) || (is_array($accountableDoc) && empty($accountableDoc))) {
            unset($this->AccountableDoc);
        } else {
            $this->AccountableDoc = $accountableDoc;
        }
        return $this;
    }
    /**
     * Get DirectBill value
     * @return \StructType\DirectBillType
     */
    public function getDirectBill()
    {
        return isset($this->DirectBill) ? $this->DirectBill : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirectBill method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectBill method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirectBillForChoiceConstraintsFromSetDirectBill($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OtherPaymentMethod',
            'PaymentCard',
            'PaymentRedirectionResponse',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DirectBill can\'t be set as the property %s is already set. Only one property must be set among these properties: DirectBill, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DirectBill value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DirectBillType $directBill
     * @return \StructType\RefundFOP_Type
     */
    public function setDirectBill(\StructType\DirectBillType $directBill = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($directBillChoiceErrorMessage = self::validateDirectBillForChoiceConstraintsFromSetDirectBill($directBill))) {
            throw new \InvalidArgumentException($directBillChoiceErrorMessage, __LINE__);
        }
        if (is_null($directBill) || (is_array($directBill) && empty($directBill))) {
            unset($this->DirectBill);
        } else {
            $this->DirectBill = $directBill;
        }
        return $this;
    }
    /**
     * Get IATA_EasyPay value
     * @return \StructType\PaymentProcessingIATA_EasyPayType
     */
    public function getIATA_EasyPay()
    {
        return isset($this->IATA_EasyPay) ? $this->IATA_EasyPay : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIATA_EasyPay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIATA_EasyPay method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIATA_EasyPayForChoiceConstraintsFromSetIATA_EasyPay($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'DirectBill',
            'LoyaltyRedemption',
            'OtherPaymentMethod',
            'PaymentCard',
            'PaymentRedirectionResponse',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property IATA_EasyPay can\'t be set as the property %s is already set. Only one property must be set among these properties: IATA_EasyPay, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set IATA_EasyPay value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingIATA_EasyPayType $iATA_EasyPay
     * @return \StructType\RefundFOP_Type
     */
    public function setIATA_EasyPay(\StructType\PaymentProcessingIATA_EasyPayType $iATA_EasyPay = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($iATA_EasyPayChoiceErrorMessage = self::validateIATA_EasyPayForChoiceConstraintsFromSetIATA_EasyPay($iATA_EasyPay))) {
            throw new \InvalidArgumentException($iATA_EasyPayChoiceErrorMessage, __LINE__);
        }
        if (is_null($iATA_EasyPay) || (is_array($iATA_EasyPay) && empty($iATA_EasyPay))) {
            unset($this->IATA_EasyPay);
        } else {
            $this->IATA_EasyPay = $iATA_EasyPay;
        }
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \StructType\LoyaltyRedemptionType
     */
    public function getLoyaltyRedemption()
    {
        return isset($this->LoyaltyRedemption) ? $this->LoyaltyRedemption : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLoyaltyRedemption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyRedemption method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoyaltyRedemptionForChoiceConstraintsFromSetLoyaltyRedemption($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'DirectBill',
            'IATA_EasyPay',
            'OtherPaymentMethod',
            'PaymentCard',
            'PaymentRedirectionResponse',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LoyaltyRedemption can\'t be set as the property %s is already set. Only one property must be set among these properties: LoyaltyRedemption, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LoyaltyRedemption value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyRedemptionType $loyaltyRedemption
     * @return \StructType\RefundFOP_Type
     */
    public function setLoyaltyRedemption(\StructType\LoyaltyRedemptionType $loyaltyRedemption = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($loyaltyRedemptionChoiceErrorMessage = self::validateLoyaltyRedemptionForChoiceConstraintsFromSetLoyaltyRedemption($loyaltyRedemption))) {
            throw new \InvalidArgumentException($loyaltyRedemptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($loyaltyRedemption) || (is_array($loyaltyRedemption) && empty($loyaltyRedemption))) {
            unset($this->LoyaltyRedemption);
        } else {
            $this->LoyaltyRedemption = $loyaltyRedemption;
        }
        return $this;
    }
    /**
     * Get OtherPaymentMethod value
     * @return \StructType\OtherPaymentMethodType
     */
    public function getOtherPaymentMethod()
    {
        return isset($this->OtherPaymentMethod) ? $this->OtherPaymentMethod : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOtherPaymentMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherPaymentMethod method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOtherPaymentMethodForChoiceConstraintsFromSetOtherPaymentMethod($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'DirectBill',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'PaymentCard',
            'PaymentRedirectionResponse',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OtherPaymentMethod can\'t be set as the property %s is already set. Only one property must be set among these properties: OtherPaymentMethod, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OtherPaymentMethod value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OtherPaymentMethodType $otherPaymentMethod
     * @return \StructType\RefundFOP_Type
     */
    public function setOtherPaymentMethod(\StructType\OtherPaymentMethodType $otherPaymentMethod = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($otherPaymentMethodChoiceErrorMessage = self::validateOtherPaymentMethodForChoiceConstraintsFromSetOtherPaymentMethod($otherPaymentMethod))) {
            throw new \InvalidArgumentException($otherPaymentMethodChoiceErrorMessage, __LINE__);
        }
        if (is_null($otherPaymentMethod) || (is_array($otherPaymentMethod) && empty($otherPaymentMethod))) {
            unset($this->OtherPaymentMethod);
        } else {
            $this->OtherPaymentMethod = $otherPaymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \StructType\PaymentProcessingPaymentCardType
     */
    public function getPaymentCard()
    {
        return isset($this->PaymentCard) ? $this->PaymentCard : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCard method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentCardForChoiceConstraintsFromSetPaymentCard($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'DirectBill',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OtherPaymentMethod',
            'PaymentRedirectionResponse',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentCard can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentCard, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentCard value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingPaymentCardType $paymentCard
     * @return \StructType\RefundFOP_Type
     */
    public function setPaymentCard(\StructType\PaymentProcessingPaymentCardType $paymentCard = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($paymentCardChoiceErrorMessage = self::validatePaymentCardForChoiceConstraintsFromSetPaymentCard($paymentCard))) {
            throw new \InvalidArgumentException($paymentCardChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentCard) || (is_array($paymentCard) && empty($paymentCard))) {
            unset($this->PaymentCard);
        } else {
            $this->PaymentCard = $paymentCard;
        }
        return $this;
    }
    /**
     * Get PaymentRedirectionResponse value
     * @return \StructType\PaymentRedirectionResponseType
     */
    public function getPaymentRedirectionResponse()
    {
        return isset($this->PaymentRedirectionResponse) ? $this->PaymentRedirectionResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentRedirectionResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentRedirectionResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentRedirectionResponseForChoiceConstraintsFromSetPaymentRedirectionResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'DirectBill',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OtherPaymentMethod',
            'PaymentCard',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentRedirectionResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentRedirectionResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentRedirectionResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentRedirectionResponseType $paymentRedirectionResponse
     * @return \StructType\RefundFOP_Type
     */
    public function setPaymentRedirectionResponse(\StructType\PaymentRedirectionResponseType $paymentRedirectionResponse = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($paymentRedirectionResponseChoiceErrorMessage = self::validatePaymentRedirectionResponseForChoiceConstraintsFromSetPaymentRedirectionResponse($paymentRedirectionResponse))) {
            throw new \InvalidArgumentException($paymentRedirectionResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentRedirectionResponse) || (is_array($paymentRedirectionResponse) && empty($paymentRedirectionResponse))) {
            unset($this->PaymentRedirectionResponse);
        } else {
            $this->PaymentRedirectionResponse = $paymentRedirectionResponse;
        }
        return $this;
    }
    /**
     * Get SettlementPlan value
     * @return \StructType\SettlementPlanType
     */
    public function getSettlementPlan()
    {
        return isset($this->SettlementPlan) ? $this->SettlementPlan : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSettlementPlan method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlementPlan method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSettlementPlanForChoiceConstraintsFromSetSettlementPlan($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'DirectBill',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OtherPaymentMethod',
            'PaymentCard',
            'PaymentRedirectionResponse',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SettlementPlan can\'t be set as the property %s is already set. Only one property must be set among these properties: SettlementPlan, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SettlementPlan value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SettlementPlanType $settlementPlan
     * @return \StructType\RefundFOP_Type
     */
    public function setSettlementPlan(\StructType\SettlementPlanType $settlementPlan = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($settlementPlanChoiceErrorMessage = self::validateSettlementPlanForChoiceConstraintsFromSetSettlementPlan($settlementPlan))) {
            throw new \InvalidArgumentException($settlementPlanChoiceErrorMessage, __LINE__);
        }
        if (is_null($settlementPlan) || (is_array($settlementPlan) && empty($settlementPlan))) {
            unset($this->SettlementPlan);
        } else {
            $this->SettlementPlan = $settlementPlan;
        }
        return $this;
    }
    /**
     * Get Voucher value
     * @return \StructType\VoucherType
     */
    public function getVoucher()
    {
        return isset($this->Voucher) ? $this->Voucher : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVoucher method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoucher method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVoucherForChoiceConstraintsFromSetVoucher($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'DirectBill',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OtherPaymentMethod',
            'PaymentCard',
            'PaymentRedirectionResponse',
            'SettlementPlan',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Voucher can\'t be set as the property %s is already set. Only one property must be set among these properties: Voucher, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Voucher value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherType $voucher
     * @return \StructType\RefundFOP_Type
     */
    public function setVoucher(\StructType\VoucherType $voucher = null)
    {
        // validation for constraint: choice(AccountableDoc, DirectBill, IATA_EasyPay, LoyaltyRedemption, OtherPaymentMethod, PaymentCard, PaymentRedirectionResponse, SettlementPlan, Voucher)
        if ('' !== ($voucherChoiceErrorMessage = self::validateVoucherForChoiceConstraintsFromSetVoucher($voucher))) {
            throw new \InvalidArgumentException($voucherChoiceErrorMessage, __LINE__);
        }
        if (is_null($voucher) || (is_array($voucher) && empty($voucher))) {
            unset($this->Voucher);
        } else {
            $this->Voucher = $voucher;
        }
        return $this;
    }
}
