<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedemptionAmountCalc StructType
 * Meta information extracted from the WSDL
 * - documentation: Redemption Amount Calculation
 * @subpackage Structs
 */
class RedemptionAmountCalc extends AbstractStructBase
{
    /**
     * The DatedMarketingSegmentRefID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentRefID
     */
    public $DatedMarketingSegmentRefID;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Operation
     */
    public $Operation;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Summary (one line) event description | Description of the offer | Tax or surcharge description. Example: US national transportation | Surcharge descriptions as free form text.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * - minOccurs: 0
     * - type: xs:string
     * @var string
     */
    public $Description;
    /**
     * Constructor method for RedemptionAmountCalc
     * @uses RedemptionAmountCalc::setDatedMarketingSegmentRefID()
     * @uses RedemptionAmountCalc::setOperation()
     * @uses RedemptionAmountCalc::setDescription()
     * @param \StructType\DatedMarketingSegmentRefID $datedMarketingSegmentRefID
     * @param \StructType\Operation $operation
     * @param string $description
     */
    public function __construct(\StructType\DatedMarketingSegmentRefID $datedMarketingSegmentRefID = null, \StructType\Operation $operation = null, $description = null)
    {
        $this
            ->setDatedMarketingSegmentRefID($datedMarketingSegmentRefID)
            ->setOperation($operation)
            ->setDescription($description);
    }
    /**
     * Get DatedMarketingSegmentRefID value
     * @return \StructType\DatedMarketingSegmentRefID|null
     */
    public function getDatedMarketingSegmentRefID()
    {
        return $this->DatedMarketingSegmentRefID;
    }
    /**
     * Set DatedMarketingSegmentRefID value
     * @param \StructType\DatedMarketingSegmentRefID $datedMarketingSegmentRefID
     * @return \StructType\RedemptionAmountCalc
     */
    public function setDatedMarketingSegmentRefID(\StructType\DatedMarketingSegmentRefID $datedMarketingSegmentRefID = null)
    {
        $this->DatedMarketingSegmentRefID = $datedMarketingSegmentRefID;
        return $this;
    }
    /**
     * Get Operation value
     * @return \StructType\Operation|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param \StructType\Operation $operation
     * @return \StructType\RedemptionAmountCalc
     */
    public function setOperation(\StructType\Operation $operation = null)
    {
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\RedemptionAmountCalc
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($description) && mb_strlen($description) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($description) && mb_strlen($description) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
