<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProgramCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: A negotiated program identifier ( e.g. CLID, Corporate codes ) to be passed between seller and retailer.
 * @subpackage Structs
 */
class ProgramCriteriaType extends AbstractStructBase
{
    /**
     * The ProgramOwner
     * Meta information extracted from the WSDL
     * - documentation: Program Owner Information
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ProgramOwnerType
     */
    public $ProgramOwner;
    /**
     * The CompanyIndexText
     * Meta information extracted from the WSDL
     * - documentation: Company profile index associated with this special fare. Example: COM1234 | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyIndexText;
    /**
     * The MemberStatusText
     * Meta information extracted from the WSDL
     * - documentation: Member or participant status within the program (e.g. VP, Director, Exec). | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MemberStatusText;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the program. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The PrePaidCertificate
     * Meta information extracted from the WSDL
     * - documentation: A Pre-Paid Certificate
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PrePaidCertificateType[]
     */
    public $PrePaidCertificate;
    /**
     * The ProgamContract
     * Meta information extracted from the WSDL
     * - documentation: An agreement which provides access to discounted or negotiated prices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProgamContractType
     */
    public $ProgamContract;
    /**
     * The ProgramAccount
     * Meta information extracted from the WSDL
     * - documentation: An account which provides access to discounted or negotiated prices.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProgramAccountType[]
     */
    public $ProgramAccount;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Program type code (e.g. Discount Program, Incentive Program, Pre-paid Program). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCode;
    /**
     * Constructor method for ProgramCriteriaType
     * @uses ProgramCriteriaType::setProgramOwner()
     * @uses ProgramCriteriaType::setCompanyIndexText()
     * @uses ProgramCriteriaType::setMemberStatusText()
     * @uses ProgramCriteriaType::setName()
     * @uses ProgramCriteriaType::setPrePaidCertificate()
     * @uses ProgramCriteriaType::setProgamContract()
     * @uses ProgramCriteriaType::setProgramAccount()
     * @uses ProgramCriteriaType::setTypeCode()
     * @param \StructType\ProgramOwnerType $programOwner
     * @param string $companyIndexText
     * @param string $memberStatusText
     * @param string $name
     * @param \StructType\PrePaidCertificateType[] $prePaidCertificate
     * @param \StructType\ProgamContractType $progamContract
     * @param \StructType\ProgramAccountType[] $programAccount
     * @param string $typeCode
     */
    public function __construct(\StructType\ProgramOwnerType $programOwner = null, $companyIndexText = null, $memberStatusText = null, $name = null, array $prePaidCertificate = array(), \StructType\ProgamContractType $progamContract = null, array $programAccount = array(), $typeCode = null)
    {
        $this
            ->setProgramOwner($programOwner)
            ->setCompanyIndexText($companyIndexText)
            ->setMemberStatusText($memberStatusText)
            ->setName($name)
            ->setPrePaidCertificate($prePaidCertificate)
            ->setProgamContract($progamContract)
            ->setProgramAccount($programAccount)
            ->setTypeCode($typeCode);
    }
    /**
     * Get ProgramOwner value
     * @return \StructType\ProgramOwnerType
     */
    public function getProgramOwner()
    {
        return $this->ProgramOwner;
    }
    /**
     * Set ProgramOwner value
     * @param \StructType\ProgramOwnerType $programOwner
     * @return \StructType\ProgramCriteriaType
     */
    public function setProgramOwner(\StructType\ProgramOwnerType $programOwner = null)
    {
        $this->ProgramOwner = $programOwner;
        return $this;
    }
    /**
     * Get CompanyIndexText value
     * @return string|null
     */
    public function getCompanyIndexText()
    {
        return $this->CompanyIndexText;
    }
    /**
     * Set CompanyIndexText value
     * @param string $companyIndexText
     * @return \StructType\ProgramCriteriaType
     */
    public function setCompanyIndexText($companyIndexText = null)
    {
        // validation for constraint: string
        if (!is_null($companyIndexText) && !is_string($companyIndexText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyIndexText, true), gettype($companyIndexText)), __LINE__);
        }
        $this->CompanyIndexText = $companyIndexText;
        return $this;
    }
    /**
     * Get MemberStatusText value
     * @return string|null
     */
    public function getMemberStatusText()
    {
        return $this->MemberStatusText;
    }
    /**
     * Set MemberStatusText value
     * @param string $memberStatusText
     * @return \StructType\ProgramCriteriaType
     */
    public function setMemberStatusText($memberStatusText = null)
    {
        // validation for constraint: string
        if (!is_null($memberStatusText) && !is_string($memberStatusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberStatusText, true), gettype($memberStatusText)), __LINE__);
        }
        $this->MemberStatusText = $memberStatusText;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ProgramCriteriaType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PrePaidCertificate value
     * @return \StructType\PrePaidCertificateType[]|null
     */
    public function getPrePaidCertificate()
    {
        return $this->PrePaidCertificate;
    }
    /**
     * This method is responsible for validating the values passed to the setPrePaidCertificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrePaidCertificate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrePaidCertificateForArrayConstraintsFromSetPrePaidCertificate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $programCriteriaTypePrePaidCertificateItem) {
            // validation for constraint: itemType
            if (!$programCriteriaTypePrePaidCertificateItem instanceof \StructType\PrePaidCertificateType) {
                $invalidValues[] = is_object($programCriteriaTypePrePaidCertificateItem) ? get_class($programCriteriaTypePrePaidCertificateItem) : sprintf('%s(%s)', gettype($programCriteriaTypePrePaidCertificateItem), var_export($programCriteriaTypePrePaidCertificateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PrePaidCertificate property can only contain items of type \StructType\PrePaidCertificateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PrePaidCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\PrePaidCertificateType[] $prePaidCertificate
     * @return \StructType\ProgramCriteriaType
     */
    public function setPrePaidCertificate(array $prePaidCertificate = array())
    {
        // validation for constraint: array
        if ('' !== ($prePaidCertificateArrayErrorMessage = self::validatePrePaidCertificateForArrayConstraintsFromSetPrePaidCertificate($prePaidCertificate))) {
            throw new \InvalidArgumentException($prePaidCertificateArrayErrorMessage, __LINE__);
        }
        $this->PrePaidCertificate = $prePaidCertificate;
        return $this;
    }
    /**
     * Add item to PrePaidCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\PrePaidCertificateType $item
     * @return \StructType\ProgramCriteriaType
     */
    public function addToPrePaidCertificate(\StructType\PrePaidCertificateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PrePaidCertificateType) {
            throw new \InvalidArgumentException(sprintf('The PrePaidCertificate property can only contain items of type \StructType\PrePaidCertificateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PrePaidCertificate[] = $item;
        return $this;
    }
    /**
     * Get ProgamContract value
     * @return \StructType\ProgamContractType|null
     */
    public function getProgamContract()
    {
        return $this->ProgamContract;
    }
    /**
     * Set ProgamContract value
     * @param \StructType\ProgamContractType $progamContract
     * @return \StructType\ProgramCriteriaType
     */
    public function setProgamContract(\StructType\ProgamContractType $progamContract = null)
    {
        $this->ProgamContract = $progamContract;
        return $this;
    }
    /**
     * Get ProgramAccount value
     * @return \StructType\ProgramAccountType[]|null
     */
    public function getProgramAccount()
    {
        return $this->ProgramAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setProgramAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgramAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgramAccountForArrayConstraintsFromSetProgramAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $programCriteriaTypeProgramAccountItem) {
            // validation for constraint: itemType
            if (!$programCriteriaTypeProgramAccountItem instanceof \StructType\ProgramAccountType) {
                $invalidValues[] = is_object($programCriteriaTypeProgramAccountItem) ? get_class($programCriteriaTypeProgramAccountItem) : sprintf('%s(%s)', gettype($programCriteriaTypeProgramAccountItem), var_export($programCriteriaTypeProgramAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgramAccount property can only contain items of type \StructType\ProgramAccountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgramAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramAccountType[] $programAccount
     * @return \StructType\ProgramCriteriaType
     */
    public function setProgramAccount(array $programAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($programAccountArrayErrorMessage = self::validateProgramAccountForArrayConstraintsFromSetProgramAccount($programAccount))) {
            throw new \InvalidArgumentException($programAccountArrayErrorMessage, __LINE__);
        }
        $this->ProgramAccount = $programAccount;
        return $this;
    }
    /**
     * Add item to ProgramAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramAccountType $item
     * @return \StructType\ProgramCriteriaType
     */
    public function addToProgramAccount(\StructType\ProgramAccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProgramAccountType) {
            throw new \InvalidArgumentException(sprintf('The ProgramAccount property can only contain items of type \StructType\ProgramAccountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProgramAccount[] = $item;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\ProgramCriteriaType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
}
