<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingParameterType StructType
 * Meta information extracted from the WSDL
 * - documentation: Pricing Parameters, including Simple Pricing, Award Travel, Auto Exchange, Override Currency and Tax Exemption.
 * @subpackage Structs
 */
class PricingParameterType extends AbstractStructBase
{
    /**
     * The AutoExchInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, this request is to be handled by an auto-exchange process. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AutoExchInd;
    /**
     * The AwardIncludedInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, award eligible offers to be returned in addition to priced offers. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AwardIncludedInd;
    /**
     * The AwardOnlyInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, only award eligible offers are requested. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AwardOnlyInd;
    /**
     * The IncludeUpsellOffersInd
     * Meta information extracted from the WSDL
     * - documentation: An indicator to advise the Airline that the Seller has a preference on receiving upsell offers or not. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeUpsellOffersInd;
    /**
     * The OverrideCurCode
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, override Currency Code to be returned in addition to priced offers. | Currency Code enumeration information. {codeListAgencyName}ISO{/codeListAgencyName} {codeListIdentifier}4217{/codeListIdentifier} | Additional BDT to
     * specify a currency code.
     * - base: CurCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OverrideCurCode;
    /**
     * The SimplePricingInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, simple pricing is requested for returned offers. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SimplePricingInd;
    /**
     * The TaxExemption
     * Meta information extracted from the WSDL
     * - documentation: Tax summary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxSummaryType[]
     */
    public $TaxExemption;
    /**
     * Constructor method for PricingParameterType
     * @uses PricingParameterType::setAutoExchInd()
     * @uses PricingParameterType::setAwardIncludedInd()
     * @uses PricingParameterType::setAwardOnlyInd()
     * @uses PricingParameterType::setIncludeUpsellOffersInd()
     * @uses PricingParameterType::setOverrideCurCode()
     * @uses PricingParameterType::setSimplePricingInd()
     * @uses PricingParameterType::setTaxExemption()
     * @param bool $autoExchInd
     * @param bool $awardIncludedInd
     * @param bool $awardOnlyInd
     * @param bool $includeUpsellOffersInd
     * @param string $overrideCurCode
     * @param bool $simplePricingInd
     * @param \StructType\TaxSummaryType[] $taxExemption
     */
    public function __construct($autoExchInd = null, $awardIncludedInd = null, $awardOnlyInd = null, $includeUpsellOffersInd = null, $overrideCurCode = null, $simplePricingInd = null, array $taxExemption = array())
    {
        $this
            ->setAutoExchInd($autoExchInd)
            ->setAwardIncludedInd($awardIncludedInd)
            ->setAwardOnlyInd($awardOnlyInd)
            ->setIncludeUpsellOffersInd($includeUpsellOffersInd)
            ->setOverrideCurCode($overrideCurCode)
            ->setSimplePricingInd($simplePricingInd)
            ->setTaxExemption($taxExemption);
    }
    /**
     * Get AutoExchInd value
     * @return bool|null
     */
    public function getAutoExchInd()
    {
        return $this->AutoExchInd;
    }
    /**
     * Set AutoExchInd value
     * @param bool $autoExchInd
     * @return \StructType\PricingParameterType
     */
    public function setAutoExchInd($autoExchInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoExchInd) && !is_bool($autoExchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoExchInd, true), gettype($autoExchInd)), __LINE__);
        }
        $this->AutoExchInd = $autoExchInd;
        return $this;
    }
    /**
     * Get AwardIncludedInd value
     * @return bool|null
     */
    public function getAwardIncludedInd()
    {
        return $this->AwardIncludedInd;
    }
    /**
     * Set AwardIncludedInd value
     * @param bool $awardIncludedInd
     * @return \StructType\PricingParameterType
     */
    public function setAwardIncludedInd($awardIncludedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($awardIncludedInd) && !is_bool($awardIncludedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($awardIncludedInd, true), gettype($awardIncludedInd)), __LINE__);
        }
        $this->AwardIncludedInd = $awardIncludedInd;
        return $this;
    }
    /**
     * Get AwardOnlyInd value
     * @return bool|null
     */
    public function getAwardOnlyInd()
    {
        return $this->AwardOnlyInd;
    }
    /**
     * Set AwardOnlyInd value
     * @param bool $awardOnlyInd
     * @return \StructType\PricingParameterType
     */
    public function setAwardOnlyInd($awardOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($awardOnlyInd) && !is_bool($awardOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($awardOnlyInd, true), gettype($awardOnlyInd)), __LINE__);
        }
        $this->AwardOnlyInd = $awardOnlyInd;
        return $this;
    }
    /**
     * Get IncludeUpsellOffersInd value
     * @return bool|null
     */
    public function getIncludeUpsellOffersInd()
    {
        return $this->IncludeUpsellOffersInd;
    }
    /**
     * Set IncludeUpsellOffersInd value
     * @param bool $includeUpsellOffersInd
     * @return \StructType\PricingParameterType
     */
    public function setIncludeUpsellOffersInd($includeUpsellOffersInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeUpsellOffersInd) && !is_bool($includeUpsellOffersInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeUpsellOffersInd, true), gettype($includeUpsellOffersInd)), __LINE__);
        }
        $this->IncludeUpsellOffersInd = $includeUpsellOffersInd;
        return $this;
    }
    /**
     * Get OverrideCurCode value
     * @return string|null
     */
    public function getOverrideCurCode()
    {
        return $this->OverrideCurCode;
    }
    /**
     * Set OverrideCurCode value
     * @param string $overrideCurCode
     * @return \StructType\PricingParameterType
     */
    public function setOverrideCurCode($overrideCurCode = null)
    {
        // validation for constraint: string
        if (!is_null($overrideCurCode) && !is_string($overrideCurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideCurCode, true), gettype($overrideCurCode)), __LINE__);
        }
        $this->OverrideCurCode = $overrideCurCode;
        return $this;
    }
    /**
     * Get SimplePricingInd value
     * @return bool|null
     */
    public function getSimplePricingInd()
    {
        return $this->SimplePricingInd;
    }
    /**
     * Set SimplePricingInd value
     * @param bool $simplePricingInd
     * @return \StructType\PricingParameterType
     */
    public function setSimplePricingInd($simplePricingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplePricingInd) && !is_bool($simplePricingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplePricingInd, true), gettype($simplePricingInd)), __LINE__);
        }
        $this->SimplePricingInd = $simplePricingInd;
        return $this;
    }
    /**
     * Get TaxExemption value
     * @return \StructType\TaxSummaryType[]|null
     */
    public function getTaxExemption()
    {
        return $this->TaxExemption;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxExemption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxExemption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxExemptionForArrayConstraintsFromSetTaxExemption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pricingParameterTypeTaxExemptionItem) {
            // validation for constraint: itemType
            if (!$pricingParameterTypeTaxExemptionItem instanceof \StructType\TaxSummaryType) {
                $invalidValues[] = is_object($pricingParameterTypeTaxExemptionItem) ? get_class($pricingParameterTypeTaxExemptionItem) : sprintf('%s(%s)', gettype($pricingParameterTypeTaxExemptionItem), var_export($pricingParameterTypeTaxExemptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxExemption property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxExemption value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType[] $taxExemption
     * @return \StructType\PricingParameterType
     */
    public function setTaxExemption(array $taxExemption = array())
    {
        // validation for constraint: array
        if ('' !== ($taxExemptionArrayErrorMessage = self::validateTaxExemptionForArrayConstraintsFromSetTaxExemption($taxExemption))) {
            throw new \InvalidArgumentException($taxExemptionArrayErrorMessage, __LINE__);
        }
        $this->TaxExemption = $taxExemption;
        return $this;
    }
    /**
     * Add item to TaxExemption value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType $item
     * @return \StructType\PricingParameterType
     */
    public function addToTaxExemption(\StructType\TaxSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxSummaryType) {
            throw new \InvalidArgumentException(sprintf('The TaxExemption property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxExemption[] = $item;
        return $this;
    }
}
