<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricingMethodCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
 * @subpackage Structs
 */
class PricingMethodCriteriaType extends AbstractStructBase
{
    /**
     * The BestPricingOptionText
     * Meta information extracted from the WSDL
     * - documentation: Best Available Fare Pricing Method. Examples: Y (BEST FARE IN SAME CABIN CLASS). C (BEST FARE ACROSS ALL CABIN CLASSES). N (PRICE ACCORDINGLY TO OTHER DESIGNATED PRICING PARAMETERS). | Text is a character string such as a finite set
     * of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BestPricingOptionText;
    /**
     * Constructor method for PricingMethodCriteriaType
     * @uses PricingMethodCriteriaType::setBestPricingOptionText()
     * @param string $bestPricingOptionText
     */
    public function __construct($bestPricingOptionText = null)
    {
        $this
            ->setBestPricingOptionText($bestPricingOptionText);
    }
    /**
     * Get BestPricingOptionText value
     * @return string|null
     */
    public function getBestPricingOptionText()
    {
        return $this->BestPricingOptionText;
    }
    /**
     * Set BestPricingOptionText value
     * @param string $bestPricingOptionText
     * @return \StructType\PricingMethodCriteriaType
     */
    public function setBestPricingOptionText($bestPricingOptionText = null)
    {
        // validation for constraint: string
        if (!is_null($bestPricingOptionText) && !is_string($bestPricingOptionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestPricingOptionText, true), gettype($bestPricingOptionText)), __LINE__);
        }
        $this->BestPricingOptionText = $bestPricingOptionText;
        return $this;
    }
}
