<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Priced Offer
 * @subpackage Structs
 */
class PricedOfferType extends AbstractStructBase
{
    /**
     * The AcceptOrderItemList
     * Meta information extracted from the WSDL
     * - documentation: A collection of Create Order Item's.
     * - choice: AcceptOrderItemList | SelectedOfferList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptOrderItemListType
     */
    public $AcceptOrderItemList;
    /**
     * The SelectedOfferList
     * Meta information extracted from the WSDL
     * - documentation: This is a collection of Selected Offer's
     * - choice: AcceptOrderItemList | SelectedOfferList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SelectedOfferListType
     */
    public $SelectedOfferList;
    /**
     * Constructor method for PricedOfferType
     * @uses PricedOfferType::setAcceptOrderItemList()
     * @uses PricedOfferType::setSelectedOfferList()
     * @param \StructType\AcceptOrderItemListType $acceptOrderItemList
     * @param \StructType\SelectedOfferListType $selectedOfferList
     */
    public function __construct(\StructType\AcceptOrderItemListType $acceptOrderItemList = null, \StructType\SelectedOfferListType $selectedOfferList = null)
    {
        $this
            ->setAcceptOrderItemList($acceptOrderItemList)
            ->setSelectedOfferList($selectedOfferList);
    }
    /**
     * Get AcceptOrderItemList value
     * @return \StructType\AcceptOrderItemListType
     */
    public function getAcceptOrderItemList()
    {
        return isset($this->AcceptOrderItemList) ? $this->AcceptOrderItemList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcceptOrderItemList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptOrderItemList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcceptOrderItemListForChoiceConstraintsFromSetAcceptOrderItemList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SelectedOfferList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AcceptOrderItemList can\'t be set as the property %s is already set. Only one property must be set among these properties: AcceptOrderItemList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AcceptOrderItemList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptOrderItemListType $acceptOrderItemList
     * @return \StructType\PricedOfferType
     */
    public function setAcceptOrderItemList(\StructType\AcceptOrderItemListType $acceptOrderItemList = null)
    {
        // validation for constraint: choice(AcceptOrderItemList, SelectedOfferList)
        if ('' !== ($acceptOrderItemListChoiceErrorMessage = self::validateAcceptOrderItemListForChoiceConstraintsFromSetAcceptOrderItemList($acceptOrderItemList))) {
            throw new \InvalidArgumentException($acceptOrderItemListChoiceErrorMessage, __LINE__);
        }
        if (is_null($acceptOrderItemList) || (is_array($acceptOrderItemList) && empty($acceptOrderItemList))) {
            unset($this->AcceptOrderItemList);
        } else {
            $this->AcceptOrderItemList = $acceptOrderItemList;
        }
        return $this;
    }
    /**
     * Get SelectedOfferList value
     * @return \StructType\SelectedOfferListType
     */
    public function getSelectedOfferList()
    {
        return isset($this->SelectedOfferList) ? $this->SelectedOfferList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSelectedOfferList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedOfferList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSelectedOfferListForChoiceConstraintsFromSetSelectedOfferList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptOrderItemList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SelectedOfferList can\'t be set as the property %s is already set. Only one property must be set among these properties: SelectedOfferList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SelectedOfferList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferListType $selectedOfferList
     * @return \StructType\PricedOfferType
     */
    public function setSelectedOfferList(\StructType\SelectedOfferListType $selectedOfferList = null)
    {
        // validation for constraint: choice(AcceptOrderItemList, SelectedOfferList)
        if ('' !== ($selectedOfferListChoiceErrorMessage = self::validateSelectedOfferListForChoiceConstraintsFromSetSelectedOfferList($selectedOfferList))) {
            throw new \InvalidArgumentException($selectedOfferListChoiceErrorMessage, __LINE__);
        }
        if (is_null($selectedOfferList) || (is_array($selectedOfferList) && empty($selectedOfferList))) {
            unset($this->SelectedOfferList);
        } else {
            $this->SelectedOfferList = $selectedOfferList;
        }
        return $this;
    }
}
