<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceClassListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Price Class data list definition.
 * @subpackage Structs
 */
class PriceClassListType extends AbstractStructBase
{
    /**
     * The PriceClass
     * Meta information extracted from the WSDL
     * - documentation: A price point within a particular Cabin Type (sometimes referred to as 'Fare Families').
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PriceClassType[]
     */
    public $PriceClass;
    /**
     * Constructor method for PriceClassListType
     * @uses PriceClassListType::setPriceClass()
     * @param \StructType\PriceClassType[] $priceClass
     */
    public function __construct(array $priceClass = array())
    {
        $this
            ->setPriceClass($priceClass);
    }
    /**
     * Get PriceClass value
     * @return \StructType\PriceClassType[]
     */
    public function getPriceClass()
    {
        return $this->PriceClass;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceClassForArrayConstraintsFromSetPriceClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceClassListTypePriceClassItem) {
            // validation for constraint: itemType
            if (!$priceClassListTypePriceClassItem instanceof \StructType\PriceClassType) {
                $invalidValues[] = is_object($priceClassListTypePriceClassItem) ? get_class($priceClassListTypePriceClassItem) : sprintf('%s(%s)', gettype($priceClassListTypePriceClassItem), var_export($priceClassListTypePriceClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceClass property can only contain items of type \StructType\PriceClassType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PriceClass value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceClassType[] $priceClass
     * @return \StructType\PriceClassListType
     */
    public function setPriceClass(array $priceClass = array())
    {
        // validation for constraint: array
        if ('' !== ($priceClassArrayErrorMessage = self::validatePriceClassForArrayConstraintsFromSetPriceClass($priceClass))) {
            throw new \InvalidArgumentException($priceClassArrayErrorMessage, __LINE__);
        }
        $this->PriceClass = $priceClass;
        return $this;
    }
    /**
     * Add item to PriceClass value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceClassType $item
     * @return \StructType\PriceClassListType
     */
    public function addToPriceClass(\StructType\PriceClassType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceClassType) {
            throw new \InvalidArgumentException(sprintf('The PriceClass property can only contain items of type \StructType\PriceClassType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PriceClass[] = $item;
        return $this;
    }
}
