<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostalAddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: Natural or physical address used for postal service. May be a building address, airport address, etc.
 * @subpackage Structs
 */
class PostalAddressType extends AbstractStructBase
{
    /**
     * The BuildingRoomText
     * Meta information extracted from the WSDL
     * - documentation: Additional address information including building name, room, apartment, or suite number. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildingRoomText;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: The name, expressed as text, of the city, town or village. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The ContactTypeText
     * Meta information extracted from the WSDL
     * - documentation: PADIS code list: Contact Type (to identify the technical contact type information) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactTypeText;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CountryCode;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - documentation: The name, expressed as text, of the country. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The CountrySubDivisionName
     * Meta information extracted from the WSDL
     * - documentation: The name, expressed as text, of the sub-division of a country. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountrySubDivisionName;
    /**
     * The PO_BoxCode
     * Meta information extracted from the WSDL
     * - documentation: Post office box. Example: P.O. Box 21 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PO_BoxCode;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: Postal code. Examples: 11001, 11001-2345 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The StreetText
     * Meta information extracted from the WSDL
     * - documentation: Street name and number. Examples: Main Street, 100 Main Street | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $StreetText;
    /**
     * Constructor method for PostalAddressType
     * @uses PostalAddressType::setBuildingRoomText()
     * @uses PostalAddressType::setCityName()
     * @uses PostalAddressType::setContactTypeText()
     * @uses PostalAddressType::setCountryCode()
     * @uses PostalAddressType::setCountryName()
     * @uses PostalAddressType::setCountrySubDivisionName()
     * @uses PostalAddressType::setPO_BoxCode()
     * @uses PostalAddressType::setPostalCode()
     * @uses PostalAddressType::setStreetText()
     * @param string $buildingRoomText
     * @param string $cityName
     * @param string $contactTypeText
     * @param string $countryCode
     * @param string $countryName
     * @param string $countrySubDivisionName
     * @param string $pO_BoxCode
     * @param string $postalCode
     * @param string[] $streetText
     */
    public function __construct($buildingRoomText = null, $cityName = null, $contactTypeText = null, $countryCode = null, $countryName = null, $countrySubDivisionName = null, $pO_BoxCode = null, $postalCode = null, array $streetText = array())
    {
        $this
            ->setBuildingRoomText($buildingRoomText)
            ->setCityName($cityName)
            ->setContactTypeText($contactTypeText)
            ->setCountryCode($countryCode)
            ->setCountryName($countryName)
            ->setCountrySubDivisionName($countrySubDivisionName)
            ->setPO_BoxCode($pO_BoxCode)
            ->setPostalCode($postalCode)
            ->setStreetText($streetText);
    }
    /**
     * Get BuildingRoomText value
     * @return string|null
     */
    public function getBuildingRoomText()
    {
        return $this->BuildingRoomText;
    }
    /**
     * Set BuildingRoomText value
     * @param string $buildingRoomText
     * @return \StructType\PostalAddressType
     */
    public function setBuildingRoomText($buildingRoomText = null)
    {
        // validation for constraint: string
        if (!is_null($buildingRoomText) && !is_string($buildingRoomText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingRoomText, true), gettype($buildingRoomText)), __LINE__);
        }
        $this->BuildingRoomText = $buildingRoomText;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\PostalAddressType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get ContactTypeText value
     * @return string|null
     */
    public function getContactTypeText()
    {
        return $this->ContactTypeText;
    }
    /**
     * Set ContactTypeText value
     * @param string $contactTypeText
     * @return \StructType\PostalAddressType
     */
    public function setContactTypeText($contactTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($contactTypeText) && !is_string($contactTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTypeText, true), gettype($contactTypeText)), __LINE__);
        }
        $this->ContactTypeText = $contactTypeText;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\PostalAddressType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($countryCode) && !preg_match('/[A-Z]{2}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($countryCode, true)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\PostalAddressType
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($countryName) && mb_strlen($countryName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($countryName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($countryName) && mb_strlen($countryName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get CountrySubDivisionName value
     * @return string|null
     */
    public function getCountrySubDivisionName()
    {
        return $this->CountrySubDivisionName;
    }
    /**
     * Set CountrySubDivisionName value
     * @param string $countrySubDivisionName
     * @return \StructType\PostalAddressType
     */
    public function setCountrySubDivisionName($countrySubDivisionName = null)
    {
        // validation for constraint: string
        if (!is_null($countrySubDivisionName) && !is_string($countrySubDivisionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrySubDivisionName, true), gettype($countrySubDivisionName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($countrySubDivisionName) && mb_strlen($countrySubDivisionName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($countrySubDivisionName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($countrySubDivisionName) && mb_strlen($countrySubDivisionName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($countrySubDivisionName)), __LINE__);
        }
        $this->CountrySubDivisionName = $countrySubDivisionName;
        return $this;
    }
    /**
     * Get PO_BoxCode value
     * @return string|null
     */
    public function getPO_BoxCode()
    {
        return $this->PO_BoxCode;
    }
    /**
     * Set PO_BoxCode value
     * @param string $pO_BoxCode
     * @return \StructType\PostalAddressType
     */
    public function setPO_BoxCode($pO_BoxCode = null)
    {
        // validation for constraint: string
        if (!is_null($pO_BoxCode) && !is_string($pO_BoxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_BoxCode, true), gettype($pO_BoxCode)), __LINE__);
        }
        $this->PO_BoxCode = $pO_BoxCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\PostalAddressType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get StreetText value
     * @return string[]|null
     */
    public function getStreetText()
    {
        return $this->StreetText;
    }
    /**
     * This method is responsible for validating the values passed to the setStreetText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreetText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStreetTextForArrayConstraintsFromSetStreetText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $postalAddressTypeStreetTextItem) {
            // validation for constraint: itemType
            if (!is_string($postalAddressTypeStreetTextItem)) {
                $invalidValues[] = is_object($postalAddressTypeStreetTextItem) ? get_class($postalAddressTypeStreetTextItem) : sprintf('%s(%s)', gettype($postalAddressTypeStreetTextItem), var_export($postalAddressTypeStreetTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StreetText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StreetText value
     * @throws \InvalidArgumentException
     * @param string[] $streetText
     * @return \StructType\PostalAddressType
     */
    public function setStreetText(array $streetText = array())
    {
        // validation for constraint: array
        if ('' !== ($streetTextArrayErrorMessage = self::validateStreetTextForArrayConstraintsFromSetStreetText($streetText))) {
            throw new \InvalidArgumentException($streetTextArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($streetText) && count($streetText) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($streetText)), __LINE__);
        }
        $this->StreetText = $streetText;
        return $this;
    }
    /**
     * Add item to StreetText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PostalAddressType
     */
    public function addToStreetText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StreetText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->StreetText) && count($this->StreetText) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->StreetText)), __LINE__);
        }
        $this->StreetText[] = $item;
        return $this;
    }
}
