<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceAllowanceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the maximum number of each allowable baggage type.
 * @subpackage Structs
 */
class PieceAllowanceType extends AbstractStructBase
{
    /**
     * The TotalQty
     * Meta information extracted from the WSDL
     * - documentation: Maximum pieces of baggage allowed. Example: 4 | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalQty;
    /**
     * Constructor method for PieceAllowanceType
     * @uses PieceAllowanceType::setTotalQty()
     * @param float $totalQty
     */
    public function __construct($totalQty = null)
    {
        $this
            ->setTotalQty($totalQty);
    }
    /**
     * Get TotalQty value
     * @return float
     */
    public function getTotalQty()
    {
        return $this->TotalQty;
    }
    /**
     * Set TotalQty value
     * @param float $totalQty
     * @return \StructType\PieceAllowanceType
     */
    public function setTotalQty($totalQty = null)
    {
        // validation for constraint: float
        if (!is_null($totalQty) && !(is_float($totalQty) || is_numeric($totalQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalQty, true), gettype($totalQty)), __LINE__);
        }
        $this->TotalQty = $totalQty;
        return $this;
    }
}
