<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneType StructType
 * Meta information extracted from the WSDL
 * - documentation: A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other
 * devices for data transmission via the public switched telephone network (PSTN) or other private networks.
 * @subpackage Structs
 */
class PhoneType extends AbstractStructBase
{
    /**
     * The AreaCodeNumber
     * Meta information extracted from the WSDL
     * - documentation: Phone number area code. Example: 813 Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code, area code, phone number and extension. | Text is a character string such
     * as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaCodeNumber;
    /**
     * The ContactTypeText
     * Meta information extracted from the WSDL
     * - documentation: PADIS code list: Contact Type (to identify the technical contact type information) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactTypeText;
    /**
     * The CountryDialingCode
     * Meta information extracted from the WSDL
     * - documentation: Numeric telephone dialing prefixes for the member countries of the International Telecommunication Union (ITU). Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code,
     * area code, phone number and extension. | Enumeration set for the Country Dialing Code BDT. | Additional BDT to specify the numeric telephone dialing prefixes for the member countries of the International Telecommunication Union (ITU).
     * - base: CountryDialingCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryDialingCode;
    /**
     * The ExtensionNumber
     * Meta information extracted from the WSDL
     * - documentation: Phone extension number. Example: 1234 Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code, area code, phone number and extension. | Text is a character string such
     * as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtensionNumber;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: Phone number text. Examples: +1 999-999-9999 ext 1234, 617-9976 Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with additional attributes country dialing code, area code and
     * extension to create a structured phone number. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * Constructor method for PhoneType
     * @uses PhoneType::setAreaCodeNumber()
     * @uses PhoneType::setContactTypeText()
     * @uses PhoneType::setCountryDialingCode()
     * @uses PhoneType::setExtensionNumber()
     * @uses PhoneType::setPhoneNumber()
     * @param string $areaCodeNumber
     * @param string $contactTypeText
     * @param string $countryDialingCode
     * @param string $extensionNumber
     * @param string $phoneNumber
     */
    public function __construct($areaCodeNumber = null, $contactTypeText = null, $countryDialingCode = null, $extensionNumber = null, $phoneNumber = null)
    {
        $this
            ->setAreaCodeNumber($areaCodeNumber)
            ->setContactTypeText($contactTypeText)
            ->setCountryDialingCode($countryDialingCode)
            ->setExtensionNumber($extensionNumber)
            ->setPhoneNumber($phoneNumber);
    }
    /**
     * Get AreaCodeNumber value
     * @return string|null
     */
    public function getAreaCodeNumber()
    {
        return $this->AreaCodeNumber;
    }
    /**
     * Set AreaCodeNumber value
     * @param string $areaCodeNumber
     * @return \StructType\PhoneType
     */
    public function setAreaCodeNumber($areaCodeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($areaCodeNumber) && !is_string($areaCodeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaCodeNumber, true), gettype($areaCodeNumber)), __LINE__);
        }
        $this->AreaCodeNumber = $areaCodeNumber;
        return $this;
    }
    /**
     * Get ContactTypeText value
     * @return string|null
     */
    public function getContactTypeText()
    {
        return $this->ContactTypeText;
    }
    /**
     * Set ContactTypeText value
     * @param string $contactTypeText
     * @return \StructType\PhoneType
     */
    public function setContactTypeText($contactTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($contactTypeText) && !is_string($contactTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTypeText, true), gettype($contactTypeText)), __LINE__);
        }
        $this->ContactTypeText = $contactTypeText;
        return $this;
    }
    /**
     * Get CountryDialingCode value
     * @return string|null
     */
    public function getCountryDialingCode()
    {
        return $this->CountryDialingCode;
    }
    /**
     * Set CountryDialingCode value
     * @param string $countryDialingCode
     * @return \StructType\PhoneType
     */
    public function setCountryDialingCode($countryDialingCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryDialingCode) && !is_string($countryDialingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryDialingCode, true), gettype($countryDialingCode)), __LINE__);
        }
        $this->CountryDialingCode = $countryDialingCode;
        return $this;
    }
    /**
     * Get ExtensionNumber value
     * @return string|null
     */
    public function getExtensionNumber()
    {
        return $this->ExtensionNumber;
    }
    /**
     * Set ExtensionNumber value
     * @param string $extensionNumber
     * @return \StructType\PhoneType
     */
    public function setExtensionNumber($extensionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($extensionNumber) && !is_string($extensionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extensionNumber, true), gettype($extensionNumber)), __LINE__);
        }
        $this->ExtensionNumber = $extensionNumber;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\PhoneType
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
}
