<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Penalty reference information.
 * @subpackage Structs
 */
class PenaltyRefType extends AbstractStructBase
{
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PenaltyRefID;
    /**
     * Constructor method for PenaltyRefType
     * @uses PenaltyRefType::setPenaltyRefID()
     * @param string $penaltyRefID
     */
    public function __construct($penaltyRefID = null)
    {
        $this
            ->setPenaltyRefID($penaltyRefID);
    }
    /**
     * Get PenaltyRefID value
     * @return string|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * Set PenaltyRefID value
     * @param string $penaltyRefID
     * @return \StructType\PenaltyRefType
     */
    public function setPenaltyRefID($penaltyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyRefID) && !is_string($penaltyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($penaltyRefID, true), gettype($penaltyRefID)), __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
}
