<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyInfoPriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a specialization of price when associated with a Penalty Info. Definition is: The Amount of money expected, required, or given in payment for something.
 * @subpackage Structs
 */
class PenaltyInfoPriceType extends AbstractStructBase
{
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - documentation: Total Base Fare Amount. Example: 200000
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $BaseAmount;
    /**
     * The CurConversion
     * Meta information extracted from the WSDL
     * - documentation: The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurConversionType[]
     */
    public $CurConversion;
    /**
     * The EquivAmount
     * Meta information extracted from the WSDL
     * - documentation: The entire amount of transaction stated in the local currency at the point of sale, or the currency as defined by the Currency Indicator Code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $EquivAmount;
    /**
     * The LoyaltyUnitAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount specified in loyalty units. Note: the 'Currency Code' sup for this BDT should not be populated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LoyaltyAmountType
     */
    public $LoyaltyUnitAmount;
    /**
     * The LoyaltyUnitName
     * Meta information extracted from the WSDL
     * - documentation: The name of the loyalty unit used by the loyalty unit amount (e.g. miles or points). | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoyaltyUnitName;
    /**
     * The TaxSummary
     * Meta information extracted from the WSDL
     * - documentation: Tax summary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Total monetary price amount, including all tax, surcharge, and fee amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalAmount;
    /**
     * Constructor method for PenaltyInfoPriceType
     * @uses PenaltyInfoPriceType::setBaseAmount()
     * @uses PenaltyInfoPriceType::setCurConversion()
     * @uses PenaltyInfoPriceType::setEquivAmount()
     * @uses PenaltyInfoPriceType::setLoyaltyUnitAmount()
     * @uses PenaltyInfoPriceType::setLoyaltyUnitName()
     * @uses PenaltyInfoPriceType::setTaxSummary()
     * @uses PenaltyInfoPriceType::setTotalAmount()
     * @param \StructType\AmountType $baseAmount
     * @param \StructType\CurConversionType[] $curConversion
     * @param \StructType\AmountType $equivAmount
     * @param \StructType\LoyaltyAmountType $loyaltyUnitAmount
     * @param string $loyaltyUnitName
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @param \StructType\AmountType $totalAmount
     */
    public function __construct(\StructType\AmountType $baseAmount = null, array $curConversion = array(), \StructType\AmountType $equivAmount = null, \StructType\LoyaltyAmountType $loyaltyUnitAmount = null, $loyaltyUnitName = null, array $taxSummary = array(), \StructType\AmountType $totalAmount = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setCurConversion($curConversion)
            ->setEquivAmount($equivAmount)
            ->setLoyaltyUnitAmount($loyaltyUnitAmount)
            ->setLoyaltyUnitName($loyaltyUnitName)
            ->setTaxSummary($taxSummary)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get BaseAmount value
     * @return \StructType\AmountType|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param \StructType\AmountType $baseAmount
     * @return \StructType\PenaltyInfoPriceType
     */
    public function setBaseAmount(\StructType\AmountType $baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get CurConversion value
     * @return \StructType\CurConversionType[]|null
     */
    public function getCurConversion()
    {
        return $this->CurConversion;
    }
    /**
     * This method is responsible for validating the values passed to the setCurConversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurConversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurConversionForArrayConstraintsFromSetCurConversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $penaltyInfoPriceTypeCurConversionItem) {
            // validation for constraint: itemType
            if (!$penaltyInfoPriceTypeCurConversionItem instanceof \StructType\CurConversionType) {
                $invalidValues[] = is_object($penaltyInfoPriceTypeCurConversionItem) ? get_class($penaltyInfoPriceTypeCurConversionItem) : sprintf('%s(%s)', gettype($penaltyInfoPriceTypeCurConversionItem), var_export($penaltyInfoPriceTypeCurConversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CurConversion property can only contain items of type \StructType\CurConversionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CurConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurConversionType[] $curConversion
     * @return \StructType\PenaltyInfoPriceType
     */
    public function setCurConversion(array $curConversion = array())
    {
        // validation for constraint: array
        if ('' !== ($curConversionArrayErrorMessage = self::validateCurConversionForArrayConstraintsFromSetCurConversion($curConversion))) {
            throw new \InvalidArgumentException($curConversionArrayErrorMessage, __LINE__);
        }
        $this->CurConversion = $curConversion;
        return $this;
    }
    /**
     * Add item to CurConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurConversionType $item
     * @return \StructType\PenaltyInfoPriceType
     */
    public function addToCurConversion(\StructType\CurConversionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurConversionType) {
            throw new \InvalidArgumentException(sprintf('The CurConversion property can only contain items of type \StructType\CurConversionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CurConversion[] = $item;
        return $this;
    }
    /**
     * Get EquivAmount value
     * @return \StructType\AmountType|null
     */
    public function getEquivAmount()
    {
        return $this->EquivAmount;
    }
    /**
     * Set EquivAmount value
     * @param \StructType\AmountType $equivAmount
     * @return \StructType\PenaltyInfoPriceType
     */
    public function setEquivAmount(\StructType\AmountType $equivAmount = null)
    {
        $this->EquivAmount = $equivAmount;
        return $this;
    }
    /**
     * Get LoyaltyUnitAmount value
     * @return \StructType\LoyaltyAmountType|null
     */
    public function getLoyaltyUnitAmount()
    {
        return $this->LoyaltyUnitAmount;
    }
    /**
     * Set LoyaltyUnitAmount value
     * @param \StructType\LoyaltyAmountType $loyaltyUnitAmount
     * @return \StructType\PenaltyInfoPriceType
     */
    public function setLoyaltyUnitAmount(\StructType\LoyaltyAmountType $loyaltyUnitAmount = null)
    {
        $this->LoyaltyUnitAmount = $loyaltyUnitAmount;
        return $this;
    }
    /**
     * Get LoyaltyUnitName value
     * @return string|null
     */
    public function getLoyaltyUnitName()
    {
        return $this->LoyaltyUnitName;
    }
    /**
     * Set LoyaltyUnitName value
     * @param string $loyaltyUnitName
     * @return \StructType\PenaltyInfoPriceType
     */
    public function setLoyaltyUnitName($loyaltyUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyUnitName) && !is_string($loyaltyUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyUnitName, true), gettype($loyaltyUnitName)), __LINE__);
        }
        $this->LoyaltyUnitName = $loyaltyUnitName;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \StructType\TaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxSummaryForArrayConstraintsFromSetTaxSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $penaltyInfoPriceTypeTaxSummaryItem) {
            // validation for constraint: itemType
            if (!$penaltyInfoPriceTypeTaxSummaryItem instanceof \StructType\TaxSummaryType) {
                $invalidValues[] = is_object($penaltyInfoPriceTypeTaxSummaryItem) ? get_class($penaltyInfoPriceTypeTaxSummaryItem) : sprintf('%s(%s)', gettype($penaltyInfoPriceTypeTaxSummaryItem), var_export($penaltyInfoPriceTypeTaxSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @return \StructType\PenaltyInfoPriceType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($taxSummaryArrayErrorMessage = self::validateTaxSummaryForArrayConstraintsFromSetTaxSummary($taxSummary))) {
            throw new \InvalidArgumentException($taxSummaryArrayErrorMessage, __LINE__);
        }
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType $item
     * @return \StructType\PenaltyInfoPriceType
     */
    public function addToTaxSummary(\StructType\TaxSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxSummaryType) {
            throw new \InvalidArgumentException(sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \StructType\AmountType $totalAmount
     * @return \StructType\PenaltyInfoPriceType
     */
    public function setTotalAmount(\StructType\AmountType $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
