<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to a penalty applied to the requested servicing operations.
 * @subpackage Structs
 */
class PenaltyDetailsType extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: This is a specialization of price when associated with a Penalty Info. Definition is: The Amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PenaltyInfoPriceType
     */
    public $Price;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Penalty type information. Examples: Cancellation, Change, NoShow, Upgrade, Other | Penalty Type Code
     * - base: PenaltyTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeCode;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Description of the applicable penalty. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The NetInd
     * Meta information extracted from the WSDL
     * - documentation: The airline informs the seller if the penalty is netted (True) (i.e. taken from any amount that airline will owe to customer consequently to the servicing) or to be paid (False) (i.e. charged to customer upfront any servicing action,
     * and even if customer benefits from a subsequent refund/ residual value). | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NetInd;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Penalty details. See ATSB Codeset PenaltyStatus for possible values. Absence of element implies no information about the status of the penalty is available. | The possible statuses of a Penalty {codeListAgencyName}IATA
     * Code List{/codeListAgencyName} {codeListName}PENALTY Status,Coded.{/codeListName} {codeListIdentifier}PENALTYSTATUS{/codeListIdentifier} | Represents the status of an Penalty Status
     * - base: PenaltyStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for PenaltyDetailsType
     * @uses PenaltyDetailsType::setPrice()
     * @uses PenaltyDetailsType::setTypeCode()
     * @uses PenaltyDetailsType::setDescText()
     * @uses PenaltyDetailsType::setNetInd()
     * @uses PenaltyDetailsType::setStatusCode()
     * @param \StructType\PenaltyInfoPriceType $price
     * @param string $typeCode
     * @param string $descText
     * @param bool $netInd
     * @param string $statusCode
     */
    public function __construct(\StructType\PenaltyInfoPriceType $price = null, $typeCode = null, $descText = null, $netInd = null, $statusCode = null)
    {
        $this
            ->setPrice($price)
            ->setTypeCode($typeCode)
            ->setDescText($descText)
            ->setNetInd($netInd)
            ->setStatusCode($statusCode);
    }
    /**
     * Get Price value
     * @return \StructType\PenaltyInfoPriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PenaltyInfoPriceType $price
     * @return \StructType\PenaltyDetailsType
     */
    public function setPrice(\StructType\PenaltyInfoPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\PenaltyDetailsType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\PenaltyDetailsType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get NetInd value
     * @return bool|null
     */
    public function getNetInd()
    {
        return $this->NetInd;
    }
    /**
     * Set NetInd value
     * @param bool $netInd
     * @return \StructType\PenaltyDetailsType
     */
    public function setNetInd($netInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($netInd) && !is_bool($netInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($netInd, true), gettype($netInd)), __LINE__);
        }
        $this->NetInd = $netInd;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\PenaltyDetailsType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
}
