<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTimeLimitDurationType StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for a payment time limit duration.
 * @subpackage Structs
 */
class PaymentTimeLimitDurationType extends AbstractStructBase
{
    /**
     * The PaymentTimeLimitDuration
     * Meta information extracted from the WSDL
     * - documentation: Duration from the Order creation date by which payment commitment is required for a given Order Item. For example: PaymentTimeLimitDuration: 'PT48H3M6S' shows the amount of time after Order is created/changed that payment commitment
     * must be made for a given Order Item. PaymentTimeLimitDuration: 'PT0H0M0S' indicates instant payment is required for a given Order Item. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian
     * calendar time units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTimeLimitDuration;
    /**
     * Constructor method for PaymentTimeLimitDurationType
     * @uses PaymentTimeLimitDurationType::setPaymentTimeLimitDuration()
     * @param string $paymentTimeLimitDuration
     */
    public function __construct($paymentTimeLimitDuration = null)
    {
        $this
            ->setPaymentTimeLimitDuration($paymentTimeLimitDuration);
    }
    /**
     * Get PaymentTimeLimitDuration value
     * @return string|null
     */
    public function getPaymentTimeLimitDuration()
    {
        return $this->PaymentTimeLimitDuration;
    }
    /**
     * Set PaymentTimeLimitDuration value
     * @param string $paymentTimeLimitDuration
     * @return \StructType\PaymentTimeLimitDurationType
     */
    public function setPaymentTimeLimitDuration($paymentTimeLimitDuration = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTimeLimitDuration) && !is_string($paymentTimeLimitDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTimeLimitDuration, true), gettype($paymentTimeLimitDuration)), __LINE__);
        }
        $this->PaymentTimeLimitDuration = $paymentTimeLimitDuration;
        return $this;
    }
}
