<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTimeLimitDateType StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for a payment time limit date.
 * @subpackage Structs
 */
class PaymentTimeLimitDateType extends AbstractStructBase
{
    /**
     * The PaymentTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: A date/time by which payment commitment is required for a given Order Item. For example: PaymentTimeLimitDateTime: '2018-01-01T12:00:00Z' shows a static payment commitment date/time for a given Order Item. | A date time identifies a
     * date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTimeLimitDateTime;
    /**
     * Constructor method for PaymentTimeLimitDateType
     * @uses PaymentTimeLimitDateType::setPaymentTimeLimitDateTime()
     * @param string $paymentTimeLimitDateTime
     */
    public function __construct($paymentTimeLimitDateTime = null)
    {
        $this
            ->setPaymentTimeLimitDateTime($paymentTimeLimitDateTime);
    }
    /**
     * Get PaymentTimeLimitDateTime value
     * @return string|null
     */
    public function getPaymentTimeLimitDateTime()
    {
        return $this->PaymentTimeLimitDateTime;
    }
    /**
     * Set PaymentTimeLimitDateTime value
     * @param string $paymentTimeLimitDateTime
     * @return \StructType\PaymentTimeLimitDateType
     */
    public function setPaymentTimeLimitDateTime($paymentTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTimeLimitDateTime) && !is_string($paymentTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTimeLimitDateTime, true), gettype($paymentTimeLimitDateTime)), __LINE__);
        }
        $this->PaymentTimeLimitDateTime = $paymentTimeLimitDateTime;
        return $this;
    }
}
