<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRedirectionResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: contains all the instructions for the Seller on how to redirect the Payer to their hosted payment page.
 * @subpackage Structs
 */
class PaymentRedirectionResponseType extends AbstractStructBase
{
    /**
     * The ReturnURI
     * Meta information extracted from the WSDL
     * - documentation: URL of the Seller where the Payer is expected to be redirected following the payment process on the delegated checkout page. | A string of characters used to identify a resource. Such identification enables interaction with
     * representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReturnURI;
    /**
     * The ExpirationDateTime
     * Meta information extracted from the WSDL
     * - documentation: The Airline can also specify how long the pre-constructed hosted payment page will be valid until (ExpirationDateTime). | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour,
     * minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDateTime;
    /**
     * Constructor method for PaymentRedirectionResponseType
     * @uses PaymentRedirectionResponseType::setReturnURI()
     * @uses PaymentRedirectionResponseType::setExpirationDateTime()
     * @param string $returnURI
     * @param string $expirationDateTime
     */
    public function __construct($returnURI = null, $expirationDateTime = null)
    {
        $this
            ->setReturnURI($returnURI)
            ->setExpirationDateTime($expirationDateTime);
    }
    /**
     * Get ReturnURI value
     * @return string
     */
    public function getReturnURI()
    {
        return $this->ReturnURI;
    }
    /**
     * Set ReturnURI value
     * @param string $returnURI
     * @return \StructType\PaymentRedirectionResponseType
     */
    public function setReturnURI($returnURI = null)
    {
        // validation for constraint: string
        if (!is_null($returnURI) && !is_string($returnURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnURI, true), gettype($returnURI)), __LINE__);
        }
        $this->ReturnURI = $returnURI;
        return $this;
    }
    /**
     * Get ExpirationDateTime value
     * @return string|null
     */
    public function getExpirationDateTime()
    {
        return $this->ExpirationDateTime;
    }
    /**
     * Set ExpirationDateTime value
     * @param string $expirationDateTime
     * @return \StructType\PaymentRedirectionResponseType
     */
    public function setExpirationDateTime($expirationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDateTime) && !is_string($expirationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDateTime, true), gettype($expirationDateTime)), __LINE__);
        }
        $this->ExpirationDateTime = $expirationDateTime;
        return $this;
    }
}
