<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProcessingSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information relating to a payment transaction including payment status.
 * @subpackage Structs
 */
class PaymentProcessingSummaryType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount applied to the associated payment method. Example: 300 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The PaymentID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies payment information within a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentID;
    /**
     * The PaymentProcessingSummaryPaymentMethod
     * Meta information extracted from the WSDL
     * - documentation: Payment Processing Summary Payment Method is a form of procedure for the payment of goods or services plus any transactional information specific to the payment method other than the amount.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public $PaymentProcessingSummaryPaymentMethod;
    /**
     * The ClearanceData
     * Meta information extracted from the WSDL
     * - documentation: set of data, either signed or not, that delivers all that is necessary for a clearance of funds to take place when using the SwO Standard and Process. It supplies the data needed to execute the clearance using the SwO Standard and
     * Process. It is the core data required by the Clearance Manager to process a Clearance. Optionally, it can be agreed by the Clearance Payer and the Clearance Payee of the clearance
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClearanceDataType
     */
    public $ClearanceData;
    /**
     * The ContactInfoRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Payer's Contact ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactInfoRefID;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DescType
     */
    public $Desc;
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - documentation: Party committing to pay. In the case of a Credit or Debit Card this would be the Cardholder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PayerType
     */
    public $Payer;
    /**
     * The PaymentCommitmentDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date when the Payment including information about amount and payment method is accepted by ORA to be enough to lead to successful payment. | A date time identifies a date and time of day to various common resolutions: year,
     * month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCommitmentDateTime;
    /**
     * The PaymentRefID
     * Meta information extracted from the WSDL
     * - documentation: If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again. | An identifier is a character string used to uniquely identify one instance
     * of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentRefID;
    /**
     * The PaymentStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the current status of this payment information. | Enumeration values for payment status codes. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment Status, coded{/codeListName}
     * {codeListIdentifier}PAYS{/codeListIdentifier} | Core statuses to be used across E&SD to express payment information required, refer to IATA code set PAYS
     * - base: PaymentStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatusCode;
    /**
     * The PaymentTrx
     * Meta information extracted from the WSDL
     * - documentation: Additional identification and URLs used to further describe a secure payment transaction.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentTrxType
     */
    public $PaymentTrx;
    /**
     * The PriceVarianceAmount
     * Meta information extracted from the WSDL
     * - documentation: Price variance amount applied during Payment processing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PriceVarianceAmount;
    /**
     * The Promotion
     * Meta information extracted from the WSDL
     * - documentation: A Promotion and discount code criteria to be passed to the retailer airline that could influence returned offers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PromotionType[]
     */
    public $Promotion;
    /**
     * The SurchargeAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount added to the final Offer/Order price, depending on which payment method is used by the client.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $SurchargeAmount;
    /**
     * The VerificationInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this payment requires additional authentication. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $VerificationInd;
    /**
     * Constructor method for PaymentProcessingSummaryType
     * @uses PaymentProcessingSummaryType::setAmount()
     * @uses PaymentProcessingSummaryType::setPaymentID()
     * @uses PaymentProcessingSummaryType::setPaymentProcessingSummaryPaymentMethod()
     * @uses PaymentProcessingSummaryType::setClearanceData()
     * @uses PaymentProcessingSummaryType::setContactInfoRefID()
     * @uses PaymentProcessingSummaryType::setDesc()
     * @uses PaymentProcessingSummaryType::setPayer()
     * @uses PaymentProcessingSummaryType::setPaymentCommitmentDateTime()
     * @uses PaymentProcessingSummaryType::setPaymentRefID()
     * @uses PaymentProcessingSummaryType::setPaymentStatusCode()
     * @uses PaymentProcessingSummaryType::setPaymentTrx()
     * @uses PaymentProcessingSummaryType::setPriceVarianceAmount()
     * @uses PaymentProcessingSummaryType::setPromotion()
     * @uses PaymentProcessingSummaryType::setSurchargeAmount()
     * @uses PaymentProcessingSummaryType::setVerificationInd()
     * @param \StructType\AmountType $amount
     * @param string $paymentID
     * @param \StructType\PaymentProcessingSummaryPaymentMethodType $paymentProcessingSummaryPaymentMethod
     * @param \StructType\ClearanceDataType $clearanceData
     * @param string $contactInfoRefID
     * @param \StructType\DescType $desc
     * @param \StructType\PayerType $payer
     * @param string $paymentCommitmentDateTime
     * @param string $paymentRefID
     * @param string $paymentStatusCode
     * @param \StructType\PaymentTrxType $paymentTrx
     * @param \StructType\AmountType $priceVarianceAmount
     * @param \StructType\PromotionType[] $promotion
     * @param \StructType\AmountType $surchargeAmount
     * @param bool $verificationInd
     */
    public function __construct(\StructType\AmountType $amount = null, $paymentID = null, \StructType\PaymentProcessingSummaryPaymentMethodType $paymentProcessingSummaryPaymentMethod = null, \StructType\ClearanceDataType $clearanceData = null, $contactInfoRefID = null, \StructType\DescType $desc = null, \StructType\PayerType $payer = null, $paymentCommitmentDateTime = null, $paymentRefID = null, $paymentStatusCode = null, \StructType\PaymentTrxType $paymentTrx = null, \StructType\AmountType $priceVarianceAmount = null, array $promotion = array(), \StructType\AmountType $surchargeAmount = null, $verificationInd = null)
    {
        $this
            ->setAmount($amount)
            ->setPaymentID($paymentID)
            ->setPaymentProcessingSummaryPaymentMethod($paymentProcessingSummaryPaymentMethod)
            ->setClearanceData($clearanceData)
            ->setContactInfoRefID($contactInfoRefID)
            ->setDesc($desc)
            ->setPayer($payer)
            ->setPaymentCommitmentDateTime($paymentCommitmentDateTime)
            ->setPaymentRefID($paymentRefID)
            ->setPaymentStatusCode($paymentStatusCode)
            ->setPaymentTrx($paymentTrx)
            ->setPriceVarianceAmount($priceVarianceAmount)
            ->setPromotion($promotion)
            ->setSurchargeAmount($surchargeAmount)
            ->setVerificationInd($verificationInd);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PaymentID value
     * @return string
     */
    public function getPaymentID()
    {
        return $this->PaymentID;
    }
    /**
     * Set PaymentID value
     * @param string $paymentID
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPaymentID($paymentID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentID) && !is_string($paymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentID, true), gettype($paymentID)), __LINE__);
        }
        $this->PaymentID = $paymentID;
        return $this;
    }
    /**
     * Get PaymentProcessingSummaryPaymentMethod value
     * @return \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public function getPaymentProcessingSummaryPaymentMethod()
    {
        return $this->PaymentProcessingSummaryPaymentMethod;
    }
    /**
     * Set PaymentProcessingSummaryPaymentMethod value
     * @param \StructType\PaymentProcessingSummaryPaymentMethodType $paymentProcessingSummaryPaymentMethod
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPaymentProcessingSummaryPaymentMethod(\StructType\PaymentProcessingSummaryPaymentMethodType $paymentProcessingSummaryPaymentMethod = null)
    {
        $this->PaymentProcessingSummaryPaymentMethod = $paymentProcessingSummaryPaymentMethod;
        return $this;
    }
    /**
     * Get ClearanceData value
     * @return \StructType\ClearanceDataType|null
     */
    public function getClearanceData()
    {
        return $this->ClearanceData;
    }
    /**
     * Set ClearanceData value
     * @param \StructType\ClearanceDataType $clearanceData
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setClearanceData(\StructType\ClearanceDataType $clearanceData = null)
    {
        $this->ClearanceData = $clearanceData;
        return $this;
    }
    /**
     * Get ContactInfoRefID value
     * @return string|null
     */
    public function getContactInfoRefID()
    {
        return $this->ContactInfoRefID;
    }
    /**
     * Set ContactInfoRefID value
     * @param string $contactInfoRefID
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setContactInfoRefID($contactInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($contactInfoRefID) && !is_string($contactInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInfoRefID, true), gettype($contactInfoRefID)), __LINE__);
        }
        $this->ContactInfoRefID = $contactInfoRefID;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param \StructType\DescType $desc
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setDesc(\StructType\DescType $desc = null)
    {
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Get Payer value
     * @return \StructType\PayerType|null
     */
    public function getPayer()
    {
        return $this->Payer;
    }
    /**
     * Set Payer value
     * @param \StructType\PayerType $payer
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPayer(\StructType\PayerType $payer = null)
    {
        $this->Payer = $payer;
        return $this;
    }
    /**
     * Get PaymentCommitmentDateTime value
     * @return string|null
     */
    public function getPaymentCommitmentDateTime()
    {
        return $this->PaymentCommitmentDateTime;
    }
    /**
     * Set PaymentCommitmentDateTime value
     * @param string $paymentCommitmentDateTime
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPaymentCommitmentDateTime($paymentCommitmentDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCommitmentDateTime) && !is_string($paymentCommitmentDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCommitmentDateTime, true), gettype($paymentCommitmentDateTime)), __LINE__);
        }
        $this->PaymentCommitmentDateTime = $paymentCommitmentDateTime;
        return $this;
    }
    /**
     * Get PaymentRefID value
     * @return string|null
     */
    public function getPaymentRefID()
    {
        return $this->PaymentRefID;
    }
    /**
     * Set PaymentRefID value
     * @param string $paymentRefID
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPaymentRefID($paymentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRefID) && !is_string($paymentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRefID, true), gettype($paymentRefID)), __LINE__);
        }
        $this->PaymentRefID = $paymentRefID;
        return $this;
    }
    /**
     * Get PaymentStatusCode value
     * @return string|null
     */
    public function getPaymentStatusCode()
    {
        return $this->PaymentStatusCode;
    }
    /**
     * Set PaymentStatusCode value
     * @param string $paymentStatusCode
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPaymentStatusCode($paymentStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatusCode) && !is_string($paymentStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatusCode, true), gettype($paymentStatusCode)), __LINE__);
        }
        $this->PaymentStatusCode = $paymentStatusCode;
        return $this;
    }
    /**
     * Get PaymentTrx value
     * @return \StructType\PaymentTrxType|null
     */
    public function getPaymentTrx()
    {
        return $this->PaymentTrx;
    }
    /**
     * Set PaymentTrx value
     * @param \StructType\PaymentTrxType $paymentTrx
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPaymentTrx(\StructType\PaymentTrxType $paymentTrx = null)
    {
        $this->PaymentTrx = $paymentTrx;
        return $this;
    }
    /**
     * Get PriceVarianceAmount value
     * @return \StructType\AmountType|null
     */
    public function getPriceVarianceAmount()
    {
        return $this->PriceVarianceAmount;
    }
    /**
     * Set PriceVarianceAmount value
     * @param \StructType\AmountType $priceVarianceAmount
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPriceVarianceAmount(\StructType\AmountType $priceVarianceAmount = null)
    {
        $this->PriceVarianceAmount = $priceVarianceAmount;
        return $this;
    }
    /**
     * Get Promotion value
     * @return \StructType\PromotionType[]|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionForArrayConstraintsFromSetPromotion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentProcessingSummaryTypePromotionItem) {
            // validation for constraint: itemType
            if (!$paymentProcessingSummaryTypePromotionItem instanceof \StructType\PromotionType) {
                $invalidValues[] = is_object($paymentProcessingSummaryTypePromotionItem) ? get_class($paymentProcessingSummaryTypePromotionItem) : sprintf('%s(%s)', gettype($paymentProcessingSummaryTypePromotionItem), var_export($paymentProcessingSummaryTypePromotionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType[] $promotion
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setPromotion(array $promotion = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionArrayErrorMessage = self::validatePromotionForArrayConstraintsFromSetPromotion($promotion))) {
            throw new \InvalidArgumentException($promotionArrayErrorMessage, __LINE__);
        }
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType $item
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function addToPromotion(\StructType\PromotionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PromotionType) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Get SurchargeAmount value
     * @return \StructType\AmountType|null
     */
    public function getSurchargeAmount()
    {
        return $this->SurchargeAmount;
    }
    /**
     * Set SurchargeAmount value
     * @param \StructType\AmountType $surchargeAmount
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setSurchargeAmount(\StructType\AmountType $surchargeAmount = null)
    {
        $this->SurchargeAmount = $surchargeAmount;
        return $this;
    }
    /**
     * Get VerificationInd value
     * @return bool|null
     */
    public function getVerificationInd()
    {
        return $this->VerificationInd;
    }
    /**
     * Set VerificationInd value
     * @param bool $verificationInd
     * @return \StructType\PaymentProcessingSummaryType
     */
    public function setVerificationInd($verificationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($verificationInd) && !is_bool($verificationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verificationInd, true), gettype($verificationInd)), __LINE__);
        }
        $this->VerificationInd = $verificationInd;
        return $this;
    }
}
