<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProcessingSummaryPaymentMethodType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment Processing Summary Payment Method is a form of procedure for the payment of goods or services plus any transactional information specific to the payment method other than the amount.
 * @subpackage Structs
 */
class PaymentProcessingSummaryPaymentMethodType extends AbstractStructBase
{
    /**
     * The AccountableDoc
     * Meta information extracted from the WSDL
     * - documentation: A Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
     * - choice: AccountableDoc | IATA_EasyPay | LoyaltyRedemption | OfflinePayment | PaymentCard | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AccountableDocType
     */
    public $AccountableDoc;
    /**
     * The IATA_EasyPay
     * Meta information extracted from the WSDL
     * - documentation: Specialization for Payment Processing Summary. IATA EasyPay is a payment instrument with a specific remittance mechanism. This FOP is not limited to BSP.
     * - choice: AccountableDoc | IATA_EasyPay | LoyaltyRedemption | OfflinePayment | PaymentCard | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ReceiptIATA_EasyPayType
     */
    public $IATA_EasyPay;
    /**
     * The LoyaltyRedemption
     * Meta information extracted from the WSDL
     * - documentation: A form of payment by which the customer uses a virtual currency of a Loyalty Program Account (such as air miles) in exchange for goods or services.
     * - choice: AccountableDoc | IATA_EasyPay | LoyaltyRedemption | OfflinePayment | PaymentCard | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LoyaltyRedemptionType
     */
    public $LoyaltyRedemption;
    /**
     * The OfflinePayment
     * Meta information extracted from the WSDL
     * - documentation: Contains instructions from the Airline relating to payment using other payment capabilities 'offline' from EASD data exchange. For example, by use of an airline payment gateway.
     * - choice: AccountableDoc | IATA_EasyPay | LoyaltyRedemption | OfflinePayment | PaymentCard | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OfflinePaymentInstructionReceiptType
     */
    public $OfflinePayment;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - documentation: A specialization of Payment Card as part of the summary of a processed payment, defined as a device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
     * - choice: AccountableDoc | IATA_EasyPay | LoyaltyRedemption | OfflinePayment | PaymentCard | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ReceiptPaymentCardType
     */
    public $PaymentCard;
    /**
     * The SettlementPlan
     * Meta information extracted from the WSDL
     * - documentation: When related to a Carrier Fee or a Payment Method or a Payment Processing Summary.
     * - choice: AccountableDoc | IATA_EasyPay | LoyaltyRedemption | OfflinePayment | PaymentCard | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SettlementPlanType
     */
    public $SettlementPlan;
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - documentation: A document that entitles the holder to a discount or that may be exchanged for goods or services.
     * - choice: AccountableDoc | IATA_EasyPay | LoyaltyRedemption | OfflinePayment | PaymentCard | SettlementPlan | Voucher
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VoucherType
     */
    public $Voucher;
    /**
     * Constructor method for PaymentProcessingSummaryPaymentMethodType
     * @uses PaymentProcessingSummaryPaymentMethodType::setAccountableDoc()
     * @uses PaymentProcessingSummaryPaymentMethodType::setIATA_EasyPay()
     * @uses PaymentProcessingSummaryPaymentMethodType::setLoyaltyRedemption()
     * @uses PaymentProcessingSummaryPaymentMethodType::setOfflinePayment()
     * @uses PaymentProcessingSummaryPaymentMethodType::setPaymentCard()
     * @uses PaymentProcessingSummaryPaymentMethodType::setSettlementPlan()
     * @uses PaymentProcessingSummaryPaymentMethodType::setVoucher()
     * @param \StructType\AccountableDocType $accountableDoc
     * @param \StructType\ReceiptIATA_EasyPayType $iATA_EasyPay
     * @param \StructType\LoyaltyRedemptionType $loyaltyRedemption
     * @param \StructType\OfflinePaymentInstructionReceiptType $offlinePayment
     * @param \StructType\ReceiptPaymentCardType $paymentCard
     * @param \StructType\SettlementPlanType $settlementPlan
     * @param \StructType\VoucherType $voucher
     */
    public function __construct(\StructType\AccountableDocType $accountableDoc = null, \StructType\ReceiptIATA_EasyPayType $iATA_EasyPay = null, \StructType\LoyaltyRedemptionType $loyaltyRedemption = null, \StructType\OfflinePaymentInstructionReceiptType $offlinePayment = null, \StructType\ReceiptPaymentCardType $paymentCard = null, \StructType\SettlementPlanType $settlementPlan = null, \StructType\VoucherType $voucher = null)
    {
        $this
            ->setAccountableDoc($accountableDoc)
            ->setIATA_EasyPay($iATA_EasyPay)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setOfflinePayment($offlinePayment)
            ->setPaymentCard($paymentCard)
            ->setSettlementPlan($settlementPlan)
            ->setVoucher($voucher);
    }
    /**
     * Get AccountableDoc value
     * @return \StructType\AccountableDocType
     */
    public function getAccountableDoc()
    {
        return isset($this->AccountableDoc) ? $this->AccountableDoc : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccountableDoc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountableDoc method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccountableDocForChoiceConstraintsFromSetAccountableDoc($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OfflinePayment',
            'PaymentCard',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AccountableDoc can\'t be set as the property %s is already set. Only one property must be set among these properties: AccountableDoc, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AccountableDoc value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountableDocType $accountableDoc
     * @return \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public function setAccountableDoc(\StructType\AccountableDocType $accountableDoc = null)
    {
        // validation for constraint: choice(AccountableDoc, IATA_EasyPay, LoyaltyRedemption, OfflinePayment, PaymentCard, SettlementPlan, Voucher)
        if ('' !== ($accountableDocChoiceErrorMessage = self::validateAccountableDocForChoiceConstraintsFromSetAccountableDoc($accountableDoc))) {
            throw new \InvalidArgumentException($accountableDocChoiceErrorMessage, __LINE__);
        }
        if (is_null($accountableDoc) || (is_array($accountableDoc) && empty($accountableDoc))) {
            unset($this->AccountableDoc);
        } else {
            $this->AccountableDoc = $accountableDoc;
        }
        return $this;
    }
    /**
     * Get IATA_EasyPay value
     * @return \StructType\ReceiptIATA_EasyPayType
     */
    public function getIATA_EasyPay()
    {
        return isset($this->IATA_EasyPay) ? $this->IATA_EasyPay : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIATA_EasyPay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIATA_EasyPay method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIATA_EasyPayForChoiceConstraintsFromSetIATA_EasyPay($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'LoyaltyRedemption',
            'OfflinePayment',
            'PaymentCard',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property IATA_EasyPay can\'t be set as the property %s is already set. Only one property must be set among these properties: IATA_EasyPay, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set IATA_EasyPay value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiptIATA_EasyPayType $iATA_EasyPay
     * @return \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public function setIATA_EasyPay(\StructType\ReceiptIATA_EasyPayType $iATA_EasyPay = null)
    {
        // validation for constraint: choice(AccountableDoc, IATA_EasyPay, LoyaltyRedemption, OfflinePayment, PaymentCard, SettlementPlan, Voucher)
        if ('' !== ($iATA_EasyPayChoiceErrorMessage = self::validateIATA_EasyPayForChoiceConstraintsFromSetIATA_EasyPay($iATA_EasyPay))) {
            throw new \InvalidArgumentException($iATA_EasyPayChoiceErrorMessage, __LINE__);
        }
        if (is_null($iATA_EasyPay) || (is_array($iATA_EasyPay) && empty($iATA_EasyPay))) {
            unset($this->IATA_EasyPay);
        } else {
            $this->IATA_EasyPay = $iATA_EasyPay;
        }
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \StructType\LoyaltyRedemptionType
     */
    public function getLoyaltyRedemption()
    {
        return isset($this->LoyaltyRedemption) ? $this->LoyaltyRedemption : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLoyaltyRedemption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyRedemption method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLoyaltyRedemptionForChoiceConstraintsFromSetLoyaltyRedemption($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'IATA_EasyPay',
            'OfflinePayment',
            'PaymentCard',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LoyaltyRedemption can\'t be set as the property %s is already set. Only one property must be set among these properties: LoyaltyRedemption, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LoyaltyRedemption value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyRedemptionType $loyaltyRedemption
     * @return \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public function setLoyaltyRedemption(\StructType\LoyaltyRedemptionType $loyaltyRedemption = null)
    {
        // validation for constraint: choice(AccountableDoc, IATA_EasyPay, LoyaltyRedemption, OfflinePayment, PaymentCard, SettlementPlan, Voucher)
        if ('' !== ($loyaltyRedemptionChoiceErrorMessage = self::validateLoyaltyRedemptionForChoiceConstraintsFromSetLoyaltyRedemption($loyaltyRedemption))) {
            throw new \InvalidArgumentException($loyaltyRedemptionChoiceErrorMessage, __LINE__);
        }
        if (is_null($loyaltyRedemption) || (is_array($loyaltyRedemption) && empty($loyaltyRedemption))) {
            unset($this->LoyaltyRedemption);
        } else {
            $this->LoyaltyRedemption = $loyaltyRedemption;
        }
        return $this;
    }
    /**
     * Get OfflinePayment value
     * @return \StructType\OfflinePaymentInstructionReceiptType
     */
    public function getOfflinePayment()
    {
        return isset($this->OfflinePayment) ? $this->OfflinePayment : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOfflinePayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfflinePayment method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOfflinePaymentForChoiceConstraintsFromSetOfflinePayment($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'PaymentCard',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OfflinePayment can\'t be set as the property %s is already set. Only one property must be set among these properties: OfflinePayment, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OfflinePayment value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OfflinePaymentInstructionReceiptType $offlinePayment
     * @return \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public function setOfflinePayment(\StructType\OfflinePaymentInstructionReceiptType $offlinePayment = null)
    {
        // validation for constraint: choice(AccountableDoc, IATA_EasyPay, LoyaltyRedemption, OfflinePayment, PaymentCard, SettlementPlan, Voucher)
        if ('' !== ($offlinePaymentChoiceErrorMessage = self::validateOfflinePaymentForChoiceConstraintsFromSetOfflinePayment($offlinePayment))) {
            throw new \InvalidArgumentException($offlinePaymentChoiceErrorMessage, __LINE__);
        }
        if (is_null($offlinePayment) || (is_array($offlinePayment) && empty($offlinePayment))) {
            unset($this->OfflinePayment);
        } else {
            $this->OfflinePayment = $offlinePayment;
        }
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \StructType\ReceiptPaymentCardType
     */
    public function getPaymentCard()
    {
        return isset($this->PaymentCard) ? $this->PaymentCard : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCard method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentCardForChoiceConstraintsFromSetPaymentCard($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OfflinePayment',
            'SettlementPlan',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentCard can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentCard, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentCard value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiptPaymentCardType $paymentCard
     * @return \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public function setPaymentCard(\StructType\ReceiptPaymentCardType $paymentCard = null)
    {
        // validation for constraint: choice(AccountableDoc, IATA_EasyPay, LoyaltyRedemption, OfflinePayment, PaymentCard, SettlementPlan, Voucher)
        if ('' !== ($paymentCardChoiceErrorMessage = self::validatePaymentCardForChoiceConstraintsFromSetPaymentCard($paymentCard))) {
            throw new \InvalidArgumentException($paymentCardChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentCard) || (is_array($paymentCard) && empty($paymentCard))) {
            unset($this->PaymentCard);
        } else {
            $this->PaymentCard = $paymentCard;
        }
        return $this;
    }
    /**
     * Get SettlementPlan value
     * @return \StructType\SettlementPlanType
     */
    public function getSettlementPlan()
    {
        return isset($this->SettlementPlan) ? $this->SettlementPlan : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSettlementPlan method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlementPlan method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSettlementPlanForChoiceConstraintsFromSetSettlementPlan($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OfflinePayment',
            'PaymentCard',
            'Voucher',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SettlementPlan can\'t be set as the property %s is already set. Only one property must be set among these properties: SettlementPlan, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SettlementPlan value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SettlementPlanType $settlementPlan
     * @return \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public function setSettlementPlan(\StructType\SettlementPlanType $settlementPlan = null)
    {
        // validation for constraint: choice(AccountableDoc, IATA_EasyPay, LoyaltyRedemption, OfflinePayment, PaymentCard, SettlementPlan, Voucher)
        if ('' !== ($settlementPlanChoiceErrorMessage = self::validateSettlementPlanForChoiceConstraintsFromSetSettlementPlan($settlementPlan))) {
            throw new \InvalidArgumentException($settlementPlanChoiceErrorMessage, __LINE__);
        }
        if (is_null($settlementPlan) || (is_array($settlementPlan) && empty($settlementPlan))) {
            unset($this->SettlementPlan);
        } else {
            $this->SettlementPlan = $settlementPlan;
        }
        return $this;
    }
    /**
     * Get Voucher value
     * @return \StructType\VoucherType
     */
    public function getVoucher()
    {
        return isset($this->Voucher) ? $this->Voucher : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVoucher method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoucher method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVoucherForChoiceConstraintsFromSetVoucher($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AccountableDoc',
            'IATA_EasyPay',
            'LoyaltyRedemption',
            'OfflinePayment',
            'PaymentCard',
            'SettlementPlan',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Voucher can\'t be set as the property %s is already set. Only one property must be set among these properties: Voucher, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Voucher value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherType $voucher
     * @return \StructType\PaymentProcessingSummaryPaymentMethodType
     */
    public function setVoucher(\StructType\VoucherType $voucher = null)
    {
        // validation for constraint: choice(AccountableDoc, IATA_EasyPay, LoyaltyRedemption, OfflinePayment, PaymentCard, SettlementPlan, Voucher)
        if ('' !== ($voucherChoiceErrorMessage = self::validateVoucherForChoiceConstraintsFromSetVoucher($voucher))) {
            throw new \InvalidArgumentException($voucherChoiceErrorMessage, __LINE__);
        }
        if (is_null($voucher) || (is_array($voucher) && empty($voucher))) {
            unset($this->Voucher);
        } else {
            $this->Voucher = $voucher;
        }
        return $this;
    }
}
