<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProcessingClearanceDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Clearance related data provided by the party committing the payment.
 * @subpackage Structs
 */
class PaymentProcessingClearanceDataType extends AbstractStructBase
{
    /**
     * The ClearanceRoleChoice
     * Meta information extracted from the WSDL
     * - documentation: Choice by the party providing the payment processing details or committing the payment of its role in the clearance process, either a Clearance Payer or Clearance Payee.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearanceRoleChoiceType
     */
    public $ClearanceRoleChoice;
    /**
     * The NetClearanceAmount
     * Meta information extracted from the WSDL
     * - documentation: The funds to be cleared as a result of the payment commitment, the selected payment method, and the date when the funds must be remitted. It is the amount the Clearance Payer must pay to the Clearance Payee on a given Remittance Date
     * taking into consideration any funds due to the Clearance Payer by the Clearance Payee as a result of the same payment commitment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $NetClearanceAmount;
    /**
     * The ProcessRuleCode
     * Meta information extracted from the WSDL
     * - documentation: defines under what governing rules, process and reporting standard the Clearance Manager processes the clearance. Example: IATAC00 or BLTRL00 or NDCLNK0 | Character string of letters and numbers to describe the governance for the
     * Clearance process.
     * - base: xs:token
     * - length: 7
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (IATAC|BLTRL)[A-Za-z0-9]{2}
     * @var string
     */
    public $ProcessRuleCode;
    /**
     * The RemittanceDate
     * Meta information extracted from the WSDL
     * - documentation: The date when the amount in the clearance request that is paid by the Clearance Payer will have to reach the settlement manager's bank account. | A date is a Gregorian calendar representation in various common resolutions: year,
     * month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemittanceDate;
    /**
     * Constructor method for PaymentProcessingClearanceDataType
     * @uses PaymentProcessingClearanceDataType::setClearanceRoleChoice()
     * @uses PaymentProcessingClearanceDataType::setNetClearanceAmount()
     * @uses PaymentProcessingClearanceDataType::setProcessRuleCode()
     * @uses PaymentProcessingClearanceDataType::setRemittanceDate()
     * @param \StructType\ClearanceRoleChoiceType $clearanceRoleChoice
     * @param \StructType\AmountType $netClearanceAmount
     * @param string $processRuleCode
     * @param string $remittanceDate
     */
    public function __construct(\StructType\ClearanceRoleChoiceType $clearanceRoleChoice = null, \StructType\AmountType $netClearanceAmount = null, $processRuleCode = null, $remittanceDate = null)
    {
        $this
            ->setClearanceRoleChoice($clearanceRoleChoice)
            ->setNetClearanceAmount($netClearanceAmount)
            ->setProcessRuleCode($processRuleCode)
            ->setRemittanceDate($remittanceDate);
    }
    /**
     * Get ClearanceRoleChoice value
     * @return \StructType\ClearanceRoleChoiceType
     */
    public function getClearanceRoleChoice()
    {
        return $this->ClearanceRoleChoice;
    }
    /**
     * Set ClearanceRoleChoice value
     * @param \StructType\ClearanceRoleChoiceType $clearanceRoleChoice
     * @return \StructType\PaymentProcessingClearanceDataType
     */
    public function setClearanceRoleChoice(\StructType\ClearanceRoleChoiceType $clearanceRoleChoice = null)
    {
        $this->ClearanceRoleChoice = $clearanceRoleChoice;
        return $this;
    }
    /**
     * Get NetClearanceAmount value
     * @return \StructType\AmountType
     */
    public function getNetClearanceAmount()
    {
        return $this->NetClearanceAmount;
    }
    /**
     * Set NetClearanceAmount value
     * @param \StructType\AmountType $netClearanceAmount
     * @return \StructType\PaymentProcessingClearanceDataType
     */
    public function setNetClearanceAmount(\StructType\AmountType $netClearanceAmount = null)
    {
        $this->NetClearanceAmount = $netClearanceAmount;
        return $this;
    }
    /**
     * Get ProcessRuleCode value
     * @return string
     */
    public function getProcessRuleCode()
    {
        return $this->ProcessRuleCode;
    }
    /**
     * Set ProcessRuleCode value
     * @param string $processRuleCode
     * @return \StructType\PaymentProcessingClearanceDataType
     */
    public function setProcessRuleCode($processRuleCode = null)
    {
        // validation for constraint: string
        if (!is_null($processRuleCode) && !is_string($processRuleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processRuleCode, true), gettype($processRuleCode)), __LINE__);
        }
        // validation for constraint: length(7)
        if (!is_null($processRuleCode) && mb_strlen($processRuleCode) !== 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 7', mb_strlen($processRuleCode)), __LINE__);
        }
        // validation for constraint: pattern((IATAC|BLTRL)[A-Za-z0-9]{2})
        if (!is_null($processRuleCode) && !preg_match('/(IATAC|BLTRL)[A-Za-z0-9]{2}/', $processRuleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (IATAC|BLTRL)[A-Za-z0-9]{2}', var_export($processRuleCode, true)), __LINE__);
        }
        $this->ProcessRuleCode = $processRuleCode;
        return $this;
    }
    /**
     * Get RemittanceDate value
     * @return string|null
     */
    public function getRemittanceDate()
    {
        return $this->RemittanceDate;
    }
    /**
     * Set RemittanceDate value
     * @param string $remittanceDate
     * @return \StructType\PaymentProcessingClearanceDataType
     */
    public function setRemittanceDate($remittanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($remittanceDate) && !is_string($remittanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remittanceDate, true), gettype($remittanceDate)), __LINE__);
        }
        $this->RemittanceDate = $remittanceDate;
        return $this;
    }
}
