<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information relating to payer preference. This could relate to the seller or the customer depending on the preference expressed within the container.
 * @subpackage Structs
 */
class PaymentMethodCriteriaType extends AbstractStructBase
{
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Type code assigned according to ATS Codeset PAYT. Example CC for Customer Card | The type code as in 'Credit card' used for a payment. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment Type,
     * coded{/codeListName} {codeListIdentifier}PAYT{/codeListIdentifier} | Additional payment type codes for use in Enhanced and Simplified, refer to IATA code set PAYT
     * - base: PaymentTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The ClearanceCriteria
     * Meta information extracted from the WSDL
     * - documentation: communication of preference for using stated clearance process and reporting standard such as the 'SwO Standard and Process' with or without a specific Remittance Date. It supplies information about preference for given clearance
     * process and reporting standard at the time of requesting an offer or additional information about an offer, an item, or an order. It is part of the 'Payment Method Criteria', and it is relevant whenever the method of payment will require clearance of
     * funds between the partners of the sale.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ClearanceCriteriaType[]
     */
    public $ClearanceCriteria;
    /**
     * The PaymentBrandCode
     * Meta information extracted from the WSDL
     * - documentation: A Payment Brand code assigned according to ATS Codeset PAYB. Example VI for Visa | Enumeration of Additional Payment Brand codes for use in Enhanced and Simplified Distribution Standards {codeListAgencyName}IATA Code
     * List{/codeListAgencyName} {codeListName}Payment Brand, Coded{/codeListName} {codeListIdentifier}PAYB{/codeListIdentifier} | Additional Payment Brand codes for use in Enhanced and Simplified Distribution Standards, refer to IATA code set PAYB
     * - base: PaymentBrandCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentBrandCode;
    /**
     * The PaymentCriteriaAddlInfo
     * Meta information extracted from the WSDL
     * - documentation: Additional Information relating to a given Payment Method Criteria
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentCriteriaAddlInfoType
     */
    public $PaymentCriteriaAddlInfo;
    /**
     * The PaymentMethodCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Country in which the payment method was issued or created, e.g., a 'US for a card issued card in the United States or 'AU for an e-wallet account created in Australia | The code list of ISO 3166 two-alpha Country Codes
     * {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166 two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $PaymentMethodCountryCode;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * Constructor method for PaymentMethodCriteriaType
     * @uses PaymentMethodCriteriaType::setPaymentTypeCode()
     * @uses PaymentMethodCriteriaType::setClearanceCriteria()
     * @uses PaymentMethodCriteriaType::setPaymentBrandCode()
     * @uses PaymentMethodCriteriaType::setPaymentCriteriaAddlInfo()
     * @uses PaymentMethodCriteriaType::setPaymentMethodCountryCode()
     * @uses PaymentMethodCriteriaType::setPrefLevel()
     * @param string $paymentTypeCode
     * @param \StructType\ClearanceCriteriaType[] $clearanceCriteria
     * @param string $paymentBrandCode
     * @param \StructType\PaymentCriteriaAddlInfoType $paymentCriteriaAddlInfo
     * @param string $paymentMethodCountryCode
     * @param \StructType\PrefLevelType $prefLevel
     */
    public function __construct($paymentTypeCode = null, array $clearanceCriteria = array(), $paymentBrandCode = null, \StructType\PaymentCriteriaAddlInfoType $paymentCriteriaAddlInfo = null, $paymentMethodCountryCode = null, \StructType\PrefLevelType $prefLevel = null)
    {
        $this
            ->setPaymentTypeCode($paymentTypeCode)
            ->setClearanceCriteria($clearanceCriteria)
            ->setPaymentBrandCode($paymentBrandCode)
            ->setPaymentCriteriaAddlInfo($paymentCriteriaAddlInfo)
            ->setPaymentMethodCountryCode($paymentMethodCountryCode)
            ->setPrefLevel($prefLevel);
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\PaymentMethodCriteriaType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get ClearanceCriteria value
     * @return \StructType\ClearanceCriteriaType[]|null
     */
    public function getClearanceCriteria()
    {
        return $this->ClearanceCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setClearanceCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClearanceCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClearanceCriteriaForArrayConstraintsFromSetClearanceCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodCriteriaTypeClearanceCriteriaItem) {
            // validation for constraint: itemType
            if (!$paymentMethodCriteriaTypeClearanceCriteriaItem instanceof \StructType\ClearanceCriteriaType) {
                $invalidValues[] = is_object($paymentMethodCriteriaTypeClearanceCriteriaItem) ? get_class($paymentMethodCriteriaTypeClearanceCriteriaItem) : sprintf('%s(%s)', gettype($paymentMethodCriteriaTypeClearanceCriteriaItem), var_export($paymentMethodCriteriaTypeClearanceCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClearanceCriteria property can only contain items of type \StructType\ClearanceCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClearanceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ClearanceCriteriaType[] $clearanceCriteria
     * @return \StructType\PaymentMethodCriteriaType
     */
    public function setClearanceCriteria(array $clearanceCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($clearanceCriteriaArrayErrorMessage = self::validateClearanceCriteriaForArrayConstraintsFromSetClearanceCriteria($clearanceCriteria))) {
            throw new \InvalidArgumentException($clearanceCriteriaArrayErrorMessage, __LINE__);
        }
        $this->ClearanceCriteria = $clearanceCriteria;
        return $this;
    }
    /**
     * Add item to ClearanceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ClearanceCriteriaType $item
     * @return \StructType\PaymentMethodCriteriaType
     */
    public function addToClearanceCriteria(\StructType\ClearanceCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClearanceCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The ClearanceCriteria property can only contain items of type \StructType\ClearanceCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ClearanceCriteria[] = $item;
        return $this;
    }
    /**
     * Get PaymentBrandCode value
     * @return string|null
     */
    public function getPaymentBrandCode()
    {
        return $this->PaymentBrandCode;
    }
    /**
     * Set PaymentBrandCode value
     * @param string $paymentBrandCode
     * @return \StructType\PaymentMethodCriteriaType
     */
    public function setPaymentBrandCode($paymentBrandCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentBrandCode) && !is_string($paymentBrandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentBrandCode, true), gettype($paymentBrandCode)), __LINE__);
        }
        $this->PaymentBrandCode = $paymentBrandCode;
        return $this;
    }
    /**
     * Get PaymentCriteriaAddlInfo value
     * @return \StructType\PaymentCriteriaAddlInfoType|null
     */
    public function getPaymentCriteriaAddlInfo()
    {
        return $this->PaymentCriteriaAddlInfo;
    }
    /**
     * Set PaymentCriteriaAddlInfo value
     * @param \StructType\PaymentCriteriaAddlInfoType $paymentCriteriaAddlInfo
     * @return \StructType\PaymentMethodCriteriaType
     */
    public function setPaymentCriteriaAddlInfo(\StructType\PaymentCriteriaAddlInfoType $paymentCriteriaAddlInfo = null)
    {
        $this->PaymentCriteriaAddlInfo = $paymentCriteriaAddlInfo;
        return $this;
    }
    /**
     * Get PaymentMethodCountryCode value
     * @return string|null
     */
    public function getPaymentMethodCountryCode()
    {
        return $this->PaymentMethodCountryCode;
    }
    /**
     * Set PaymentMethodCountryCode value
     * @param string $paymentMethodCountryCode
     * @return \StructType\PaymentMethodCriteriaType
     */
    public function setPaymentMethodCountryCode($paymentMethodCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodCountryCode) && !is_string($paymentMethodCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodCountryCode, true), gettype($paymentMethodCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($paymentMethodCountryCode) && !preg_match('/[A-Z]{2}/', $paymentMethodCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($paymentMethodCountryCode, true)), __LINE__);
        }
        $this->PaymentMethodCountryCode = $paymentMethodCountryCode;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\PaymentMethodCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
}
