<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInfoListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
 * @subpackage Structs
 */
class PaymentInfoListType extends AbstractStructBase
{
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentInfoType[]
     */
    public $PaymentInfo;
    /**
     * Constructor method for PaymentInfoListType
     * @uses PaymentInfoListType::setPaymentInfo()
     * @param \StructType\PaymentInfoType[] $paymentInfo
     */
    public function __construct(array $paymentInfo = array())
    {
        $this
            ->setPaymentInfo($paymentInfo);
    }
    /**
     * Get PaymentInfo value
     * @return \StructType\PaymentInfoType[]|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentInfoForArrayConstraintsFromSetPaymentInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInfoListTypePaymentInfoItem) {
            // validation for constraint: itemType
            if (!$paymentInfoListTypePaymentInfoItem instanceof \StructType\PaymentInfoType) {
                $invalidValues[] = is_object($paymentInfoListTypePaymentInfoItem) ? get_class($paymentInfoListTypePaymentInfoItem) : sprintf('%s(%s)', gettype($paymentInfoListTypePaymentInfoItem), var_export($paymentInfoListTypePaymentInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentInfo property can only contain items of type \StructType\PaymentInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentInfoType[] $paymentInfo
     * @return \StructType\PaymentInfoListType
     */
    public function setPaymentInfo(array $paymentInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentInfoArrayErrorMessage = self::validatePaymentInfoForArrayConstraintsFromSetPaymentInfo($paymentInfo))) {
            throw new \InvalidArgumentException($paymentInfoArrayErrorMessage, __LINE__);
        }
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Add item to PaymentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentInfoType $item
     * @return \StructType\PaymentInfoListType
     */
    public function addToPaymentInfo(\StructType\PaymentInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentInfoType) {
            throw new \InvalidArgumentException(sprintf('The PaymentInfo property can only contain items of type \StructType\PaymentInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentInfo[] = $item;
        return $this;
    }
}
