<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: search filter by payment types
 * @subpackage Structs
 */
class PaymentFilterCriteriaType extends AbstractStructBase
{
    /**
     * The AccountableDoc
     * Meta information extracted from the WSDL
     * - documentation: A Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountableDocType
     */
    public $AccountableDoc;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount applied to the associated payment method. Example: 300 USD
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The ContactInfoRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Payer's Contact ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactInfoRefID;
    /**
     * The DirectBill
     * Meta information extracted from the WSDL
     * - documentation: System in which a corporation's travel agency bills employees for their business travel. The employee must then submit an expense accounting and be reimbursed by the corporation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DirectBillType
     */
    public $DirectBill;
    /**
     * The IATA_EasyPay
     * Meta information extracted from the WSDL
     * - documentation: IATA EasyPay is a payment instrument with a specific remittance mechanism. This FOP is not limited to BSP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IATA_EasyPayType
     */
    public $IATA_EasyPay;
    /**
     * The LoyaltyRedemption
     * Meta information extracted from the WSDL
     * - documentation: A form of payment by which the customer uses a virtual currency of a Loyalty Program Account (such as air miles) in exchange for goods or services.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LoyaltyRedemptionType
     */
    public $LoyaltyRedemption;
    /**
     * The OtherPaymentMethod
     * Meta information extracted from the WSDL
     * - documentation: Information relating to non-standard forms of payment which may be used in exchange for goods or services.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OtherPaymentMethodType
     */
    public $OtherPaymentMethod;
    /**
     * The PaymentCardCriteria
     * Meta information extracted from the WSDL
     * - documentation: Payment card specific filter criteria for shopping requests, including card issuer type and identification number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentCardCriteriaType
     */
    public $PaymentCardCriteria;
    /**
     * The PaymentInfoID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies payment information within a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInfoID;
    /**
     * The PaymentStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the current status of this payment information. | Enumeration values for payment status codes. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment Status, coded{/codeListName}
     * {codeListIdentifier}PAYS{/codeListIdentifier} | Core statuses to be used across E&SD to express payment information required, refer to IATA code set PAYS
     * - base: PaymentStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatusCode;
    /**
     * The SettlementPlan
     * Meta information extracted from the WSDL
     * - documentation: When related to a Carrier Fee or a Payment Method or a Payment Processing Summary.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SettlementPlanType
     */
    public $SettlementPlan;
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - documentation: A document that entitles the holder to a discount or that may be exchanged for goods or services.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VoucherType
     */
    public $Voucher;
    /**
     * Constructor method for PaymentFilterCriteriaType
     * @uses PaymentFilterCriteriaType::setAccountableDoc()
     * @uses PaymentFilterCriteriaType::setAmount()
     * @uses PaymentFilterCriteriaType::setContactInfoRefID()
     * @uses PaymentFilterCriteriaType::setDirectBill()
     * @uses PaymentFilterCriteriaType::setIATA_EasyPay()
     * @uses PaymentFilterCriteriaType::setLoyaltyRedemption()
     * @uses PaymentFilterCriteriaType::setOtherPaymentMethod()
     * @uses PaymentFilterCriteriaType::setPaymentCardCriteria()
     * @uses PaymentFilterCriteriaType::setPaymentInfoID()
     * @uses PaymentFilterCriteriaType::setPaymentStatusCode()
     * @uses PaymentFilterCriteriaType::setSettlementPlan()
     * @uses PaymentFilterCriteriaType::setVoucher()
     * @param \StructType\AccountableDocType $accountableDoc
     * @param \StructType\AmountType $amount
     * @param string $contactInfoRefID
     * @param \StructType\DirectBillType $directBill
     * @param \StructType\IATA_EasyPayType $iATA_EasyPay
     * @param \StructType\LoyaltyRedemptionType $loyaltyRedemption
     * @param \StructType\OtherPaymentMethodType $otherPaymentMethod
     * @param \StructType\PaymentCardCriteriaType $paymentCardCriteria
     * @param string $paymentInfoID
     * @param string $paymentStatusCode
     * @param \StructType\SettlementPlanType $settlementPlan
     * @param \StructType\VoucherType $voucher
     */
    public function __construct(\StructType\AccountableDocType $accountableDoc = null, \StructType\AmountType $amount = null, $contactInfoRefID = null, \StructType\DirectBillType $directBill = null, \StructType\IATA_EasyPayType $iATA_EasyPay = null, \StructType\LoyaltyRedemptionType $loyaltyRedemption = null, \StructType\OtherPaymentMethodType $otherPaymentMethod = null, \StructType\PaymentCardCriteriaType $paymentCardCriteria = null, $paymentInfoID = null, $paymentStatusCode = null, \StructType\SettlementPlanType $settlementPlan = null, \StructType\VoucherType $voucher = null)
    {
        $this
            ->setAccountableDoc($accountableDoc)
            ->setAmount($amount)
            ->setContactInfoRefID($contactInfoRefID)
            ->setDirectBill($directBill)
            ->setIATA_EasyPay($iATA_EasyPay)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setOtherPaymentMethod($otherPaymentMethod)
            ->setPaymentCardCriteria($paymentCardCriteria)
            ->setPaymentInfoID($paymentInfoID)
            ->setPaymentStatusCode($paymentStatusCode)
            ->setSettlementPlan($settlementPlan)
            ->setVoucher($voucher);
    }
    /**
     * Get AccountableDoc value
     * @return \StructType\AccountableDocType|null
     */
    public function getAccountableDoc()
    {
        return $this->AccountableDoc;
    }
    /**
     * Set AccountableDoc value
     * @param \StructType\AccountableDocType $accountableDoc
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setAccountableDoc(\StructType\AccountableDocType $accountableDoc = null)
    {
        $this->AccountableDoc = $accountableDoc;
        return $this;
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ContactInfoRefID value
     * @return string|null
     */
    public function getContactInfoRefID()
    {
        return $this->ContactInfoRefID;
    }
    /**
     * Set ContactInfoRefID value
     * @param string $contactInfoRefID
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setContactInfoRefID($contactInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($contactInfoRefID) && !is_string($contactInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInfoRefID, true), gettype($contactInfoRefID)), __LINE__);
        }
        $this->ContactInfoRefID = $contactInfoRefID;
        return $this;
    }
    /**
     * Get DirectBill value
     * @return \StructType\DirectBillType|null
     */
    public function getDirectBill()
    {
        return $this->DirectBill;
    }
    /**
     * Set DirectBill value
     * @param \StructType\DirectBillType $directBill
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setDirectBill(\StructType\DirectBillType $directBill = null)
    {
        $this->DirectBill = $directBill;
        return $this;
    }
    /**
     * Get IATA_EasyPay value
     * @return \StructType\IATA_EasyPayType|null
     */
    public function getIATA_EasyPay()
    {
        return $this->IATA_EasyPay;
    }
    /**
     * Set IATA_EasyPay value
     * @param \StructType\IATA_EasyPayType $iATA_EasyPay
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setIATA_EasyPay(\StructType\IATA_EasyPayType $iATA_EasyPay = null)
    {
        $this->IATA_EasyPay = $iATA_EasyPay;
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \StructType\LoyaltyRedemptionType|null
     */
    public function getLoyaltyRedemption()
    {
        return $this->LoyaltyRedemption;
    }
    /**
     * Set LoyaltyRedemption value
     * @param \StructType\LoyaltyRedemptionType $loyaltyRedemption
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setLoyaltyRedemption(\StructType\LoyaltyRedemptionType $loyaltyRedemption = null)
    {
        $this->LoyaltyRedemption = $loyaltyRedemption;
        return $this;
    }
    /**
     * Get OtherPaymentMethod value
     * @return \StructType\OtherPaymentMethodType|null
     */
    public function getOtherPaymentMethod()
    {
        return $this->OtherPaymentMethod;
    }
    /**
     * Set OtherPaymentMethod value
     * @param \StructType\OtherPaymentMethodType $otherPaymentMethod
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setOtherPaymentMethod(\StructType\OtherPaymentMethodType $otherPaymentMethod = null)
    {
        $this->OtherPaymentMethod = $otherPaymentMethod;
        return $this;
    }
    /**
     * Get PaymentCardCriteria value
     * @return \StructType\PaymentCardCriteriaType|null
     */
    public function getPaymentCardCriteria()
    {
        return $this->PaymentCardCriteria;
    }
    /**
     * Set PaymentCardCriteria value
     * @param \StructType\PaymentCardCriteriaType $paymentCardCriteria
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setPaymentCardCriteria(\StructType\PaymentCardCriteriaType $paymentCardCriteria = null)
    {
        $this->PaymentCardCriteria = $paymentCardCriteria;
        return $this;
    }
    /**
     * Get PaymentInfoID value
     * @return string|null
     */
    public function getPaymentInfoID()
    {
        return $this->PaymentInfoID;
    }
    /**
     * Set PaymentInfoID value
     * @param string $paymentInfoID
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setPaymentInfoID($paymentInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInfoID) && !is_string($paymentInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInfoID, true), gettype($paymentInfoID)), __LINE__);
        }
        $this->PaymentInfoID = $paymentInfoID;
        return $this;
    }
    /**
     * Get PaymentStatusCode value
     * @return string|null
     */
    public function getPaymentStatusCode()
    {
        return $this->PaymentStatusCode;
    }
    /**
     * Set PaymentStatusCode value
     * @param string $paymentStatusCode
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setPaymentStatusCode($paymentStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatusCode) && !is_string($paymentStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatusCode, true), gettype($paymentStatusCode)), __LINE__);
        }
        $this->PaymentStatusCode = $paymentStatusCode;
        return $this;
    }
    /**
     * Get SettlementPlan value
     * @return \StructType\SettlementPlanType|null
     */
    public function getSettlementPlan()
    {
        return $this->SettlementPlan;
    }
    /**
     * Set SettlementPlan value
     * @param \StructType\SettlementPlanType $settlementPlan
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setSettlementPlan(\StructType\SettlementPlanType $settlementPlan = null)
    {
        $this->SettlementPlan = $settlementPlan;
        return $this;
    }
    /**
     * Get Voucher value
     * @return \StructType\VoucherType|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param \StructType\VoucherType $voucher
     * @return \StructType\PaymentFilterCriteriaType
     */
    public function setVoucher(\StructType\VoucherType $voucher = null)
    {
        $this->Voucher = $voucher;
        return $this;
    }
}
