<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCardCriteriaAddlInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional Information relating to Payment Cards. For use with PaymentTypeCode(s) relating to Card forms of payment
 * @subpackage Structs
 */
class PaymentCardCriteriaAddlInfoType extends AbstractStructBase
{
    /**
     * The CardProductTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Used to specify whether the card is a Consumer (personal) or Commercial (corporate) card. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardProductTypeCode;
    /**
     * The CardTypeText
     * Meta information extracted from the WSDL
     * - documentation: Additional description for the magnetic stripe card type (debit card, credit card, prepaid card, etc.) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardTypeText;
    /**
     * The IIN_IINNumber
     * Meta information extracted from the WSDL
     * - documentation: Payment card IIN/BIN number. Example: 401123 | Issuer identification number.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $IIN_IINNumber;
    /**
     * The SecurePaymentAuthenticationVersion
     * Meta information extracted from the WSDL
     * - documentation: Used by Seller if 3D-Secure is supported. Seller can specify which version of 3D-Secure is supported. Note: 3D-Secure context should be used when the Customer-Seller interaction type is web and/or mobile.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecurePaymentAuthenticationVersionType
     */
    public $SecurePaymentAuthenticationVersion;
    /**
     * Constructor method for PaymentCardCriteriaAddlInfoType
     * @uses PaymentCardCriteriaAddlInfoType::setCardProductTypeCode()
     * @uses PaymentCardCriteriaAddlInfoType::setCardTypeText()
     * @uses PaymentCardCriteriaAddlInfoType::setIIN_IINNumber()
     * @uses PaymentCardCriteriaAddlInfoType::setSecurePaymentAuthenticationVersion()
     * @param string $cardProductTypeCode
     * @param string $cardTypeText
     * @param string $iIN_IINNumber
     * @param \StructType\SecurePaymentAuthenticationVersionType $securePaymentAuthenticationVersion
     */
    public function __construct($cardProductTypeCode = null, $cardTypeText = null, $iIN_IINNumber = null, \StructType\SecurePaymentAuthenticationVersionType $securePaymentAuthenticationVersion = null)
    {
        $this
            ->setCardProductTypeCode($cardProductTypeCode)
            ->setCardTypeText($cardTypeText)
            ->setIIN_IINNumber($iIN_IINNumber)
            ->setSecurePaymentAuthenticationVersion($securePaymentAuthenticationVersion);
    }
    /**
     * Get CardProductTypeCode value
     * @return string|null
     */
    public function getCardProductTypeCode()
    {
        return $this->CardProductTypeCode;
    }
    /**
     * Set CardProductTypeCode value
     * @param string $cardProductTypeCode
     * @return \StructType\PaymentCardCriteriaAddlInfoType
     */
    public function setCardProductTypeCode($cardProductTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardProductTypeCode) && !is_string($cardProductTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardProductTypeCode, true), gettype($cardProductTypeCode)), __LINE__);
        }
        $this->CardProductTypeCode = $cardProductTypeCode;
        return $this;
    }
    /**
     * Get CardTypeText value
     * @return string|null
     */
    public function getCardTypeText()
    {
        return $this->CardTypeText;
    }
    /**
     * Set CardTypeText value
     * @param string $cardTypeText
     * @return \StructType\PaymentCardCriteriaAddlInfoType
     */
    public function setCardTypeText($cardTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeText) && !is_string($cardTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeText, true), gettype($cardTypeText)), __LINE__);
        }
        $this->CardTypeText = $cardTypeText;
        return $this;
    }
    /**
     * Get IIN_IINNumber value
     * @return string|null
     */
    public function getIIN_IINNumber()
    {
        return $this->IIN_IINNumber;
    }
    /**
     * Set IIN_IINNumber value
     * @param string $iIN_IINNumber
     * @return \StructType\PaymentCardCriteriaAddlInfoType
     */
    public function setIIN_IINNumber($iIN_IINNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iIN_IINNumber) && !is_string($iIN_IINNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iIN_IINNumber, true), gettype($iIN_IINNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($iIN_IINNumber) && !preg_match('/[0-9]{1,8}/', $iIN_IINNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($iIN_IINNumber, true)), __LINE__);
        }
        $this->IIN_IINNumber = $iIN_IINNumber;
        return $this;
    }
    /**
     * Get SecurePaymentAuthenticationVersion value
     * @return \StructType\SecurePaymentAuthenticationVersionType|null
     */
    public function getSecurePaymentAuthenticationVersion()
    {
        return $this->SecurePaymentAuthenticationVersion;
    }
    /**
     * Set SecurePaymentAuthenticationVersion value
     * @param \StructType\SecurePaymentAuthenticationVersionType $securePaymentAuthenticationVersion
     * @return \StructType\PaymentCardCriteriaAddlInfoType
     */
    public function setSecurePaymentAuthenticationVersion(\StructType\SecurePaymentAuthenticationVersionType $securePaymentAuthenticationVersion = null)
    {
        $this->SecurePaymentAuthenticationVersion = $securePaymentAuthenticationVersion;
        return $this;
    }
}
