<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: A physical address that is associated with payment types , This comprises of a postal address and optional payment verification.
 * @subpackage Structs
 */
class PaymentAddressType extends AbstractStructBase
{
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - documentation: Natural or physical address used for postal service. May be a building address, airport address, etc.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PostalAddressType
     */
    public $PostalAddress;
    /**
     * The PaymentAddressVerification
     * Meta information extracted from the WSDL
     * - documentation: Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentAddressVerificationType
     */
    public $PaymentAddressVerification;
    /**
     * Constructor method for PaymentAddressType
     * @uses PaymentAddressType::setPostalAddress()
     * @uses PaymentAddressType::setPaymentAddressVerification()
     * @param \StructType\PostalAddressType $postalAddress
     * @param \StructType\PaymentAddressVerificationType $paymentAddressVerification
     */
    public function __construct(\StructType\PostalAddressType $postalAddress = null, \StructType\PaymentAddressVerificationType $paymentAddressVerification = null)
    {
        $this
            ->setPostalAddress($postalAddress)
            ->setPaymentAddressVerification($paymentAddressVerification);
    }
    /**
     * Get PostalAddress value
     * @return \StructType\PostalAddressType
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\PostalAddressType $postalAddress
     * @return \StructType\PaymentAddressType
     */
    public function setPostalAddress(\StructType\PostalAddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get PaymentAddressVerification value
     * @return \StructType\PaymentAddressVerificationType|null
     */
    public function getPaymentAddressVerification()
    {
        return $this->PaymentAddressVerification;
    }
    /**
     * Set PaymentAddressVerification value
     * @param \StructType\PaymentAddressVerificationType $paymentAddressVerification
     * @return \StructType\PaymentAddressType
     */
    public function setPaymentAddressVerification(\StructType\PaymentAddressVerificationType $paymentAddressVerification = null)
    {
        $this->PaymentAddressVerification = $paymentAddressVerification;
        return $this;
    }
}
