<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayerNameType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payer Name
 * @subpackage Structs
 */
class PayerNameType extends AbstractStructBase
{
    /**
     * The IndividualName
     * Meta information extracted from the WSDL
     * - documentation: A Payer individual is a specialisation of the individual type defined as: A single human being as distinct from a group, class, or family.
     * - choice: IndividualName | OrganisationName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PayerIndividualType
     */
    public $IndividualName;
    /**
     * The OrganisationName
     * Meta information extracted from the WSDL
     * - documentation: Payer Organization is a specialization of the organization type defined as: is an organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * - choice: IndividualName | OrganisationName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PayerOrganisationType
     */
    public $OrganisationName;
    /**
     * Constructor method for PayerNameType
     * @uses PayerNameType::setIndividualName()
     * @uses PayerNameType::setOrganisationName()
     * @param \StructType\PayerIndividualType $individualName
     * @param \StructType\PayerOrganisationType $organisationName
     */
    public function __construct(\StructType\PayerIndividualType $individualName = null, \StructType\PayerOrganisationType $organisationName = null)
    {
        $this
            ->setIndividualName($individualName)
            ->setOrganisationName($organisationName);
    }
    /**
     * Get IndividualName value
     * @return \StructType\PayerIndividualType
     */
    public function getIndividualName()
    {
        return isset($this->IndividualName) ? $this->IndividualName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIndividualName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIndividualName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIndividualNameForChoiceConstraintsFromSetIndividualName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OrganisationName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property IndividualName can\'t be set as the property %s is already set. Only one property must be set among these properties: IndividualName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set IndividualName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PayerIndividualType $individualName
     * @return \StructType\PayerNameType
     */
    public function setIndividualName(\StructType\PayerIndividualType $individualName = null)
    {
        // validation for constraint: choice(IndividualName, OrganisationName)
        if ('' !== ($individualNameChoiceErrorMessage = self::validateIndividualNameForChoiceConstraintsFromSetIndividualName($individualName))) {
            throw new \InvalidArgumentException($individualNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($individualName) || (is_array($individualName) && empty($individualName))) {
            unset($this->IndividualName);
        } else {
            $this->IndividualName = $individualName;
        }
        return $this;
    }
    /**
     * Get OrganisationName value
     * @return \StructType\PayerOrganisationType
     */
    public function getOrganisationName()
    {
        return isset($this->OrganisationName) ? $this->OrganisationName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrganisationName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganisationName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrganisationNameForChoiceConstraintsFromSetOrganisationName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'IndividualName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OrganisationName can\'t be set as the property %s is already set. Only one property must be set among these properties: OrganisationName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OrganisationName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PayerOrganisationType $organisationName
     * @return \StructType\PayerNameType
     */
    public function setOrganisationName(\StructType\PayerOrganisationType $organisationName = null)
    {
        // validation for constraint: choice(IndividualName, OrganisationName)
        if ('' !== ($organisationNameChoiceErrorMessage = self::validateOrganisationNameForChoiceConstraintsFromSetOrganisationName($organisationName))) {
            throw new \InvalidArgumentException($organisationNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($organisationName) || (is_array($organisationName) && empty($organisationName))) {
            unset($this->OrganisationName);
        } else {
            $this->OrganisationName = $organisationName;
        }
        return $this;
    }
}
