<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayerIndividualType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Payer individual is a specialisation of the individual type defined as: A single human being as distinct from a group, class, or family.
 * @subpackage Structs
 */
class PayerIndividualType extends AbstractStructBase
{
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - documentation: Individual's hereditary name(s) common to all members of a family. Also known as family name or last name. E.g. SMITH. Excludes any potential suffix. | BDT with value constraints for proper, regular names (e.g. Individual Surname,
     * Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Surname;
    /**
     * The BirthplaceText
     * Meta information extracted from the WSDL
     * - documentation: Country Code where the Passenger was born (ISO 3166). For example: DE | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthplaceText;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: A personal name given to the individual at birth and used before a family name. Also called first name. E.g. JOHN. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name,
     * etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $GivenName;
    /**
     * The IndividualID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies an Individual within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IndividualID;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: Individual's middle name or initial. E.g. G, GEORGE. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $MiddleName;
    /**
     * The SuffixName
     * Meta information extracted from the WSDL
     * - documentation: Individual's name suffixes and letters. Examples: Jr., Sr., III, Ret., Esq. | BDT with value constraints for short supplements to proper names, such as Title, Suffix, etc.
     * - base: xs:token
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuffixName;
    /**
     * The TitleName
     * Meta information extracted from the WSDL
     * - documentation: A word such as Mr., Mrs., Miss or Dr that is used before an individual's name to indicate the gender, profession or marital status. | BDT with value constraints for short supplements to proper names, such as Title, Suffix, etc.
     * - base: xs:token
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TitleName;
    /**
     * Constructor method for PayerIndividualType
     * @uses PayerIndividualType::setSurname()
     * @uses PayerIndividualType::setBirthplaceText()
     * @uses PayerIndividualType::setGivenName()
     * @uses PayerIndividualType::setIndividualID()
     * @uses PayerIndividualType::setMiddleName()
     * @uses PayerIndividualType::setSuffixName()
     * @uses PayerIndividualType::setTitleName()
     * @param string $surname
     * @param string $birthplaceText
     * @param string[] $givenName
     * @param string $individualID
     * @param string[] $middleName
     * @param string $suffixName
     * @param string $titleName
     */
    public function __construct($surname = null, $birthplaceText = null, array $givenName = array(), $individualID = null, array $middleName = array(), $suffixName = null, $titleName = null)
    {
        $this
            ->setSurname($surname)
            ->setBirthplaceText($birthplaceText)
            ->setGivenName($givenName)
            ->setIndividualID($individualID)
            ->setMiddleName($middleName)
            ->setSuffixName($suffixName)
            ->setTitleName($titleName);
    }
    /**
     * Get Surname value
     * @return string
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\PayerIndividualType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($surname) && mb_strlen($surname) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($surname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($surname) && mb_strlen($surname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get BirthplaceText value
     * @return string|null
     */
    public function getBirthplaceText()
    {
        return $this->BirthplaceText;
    }
    /**
     * Set BirthplaceText value
     * @param string $birthplaceText
     * @return \StructType\PayerIndividualType
     */
    public function setBirthplaceText($birthplaceText = null)
    {
        // validation for constraint: string
        if (!is_null($birthplaceText) && !is_string($birthplaceText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthplaceText, true), gettype($birthplaceText)), __LINE__);
        }
        $this->BirthplaceText = $birthplaceText;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * This method is responsible for validating the values passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForArrayConstraintsFromSetGivenName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payerIndividualTypeGivenNameItem) {
            // validation for constraint: itemType
            if (!is_string($payerIndividualTypeGivenNameItem)) {
                $invalidValues[] = is_object($payerIndividualTypeGivenNameItem) ? get_class($payerIndividualTypeGivenNameItem) : sprintf('%s(%s)', gettype($payerIndividualTypeGivenNameItem), var_export($payerIndividualTypeGivenNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GivenName property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMaxLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payerIndividualTypeGivenNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($payerIndividualTypeGivenNameItem) > 64) {
                $invalidValues[] = var_export($payerIndividualTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMinLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payerIndividualTypeGivenNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($payerIndividualTypeGivenNameItem) < 1) {
                $invalidValues[] = var_export($payerIndividualTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param string[] $givenName
     * @return \StructType\PayerIndividualType
     */
    public function setGivenName(array $givenName = array())
    {
        // validation for constraint: array
        if ('' !== ($givenNameArrayErrorMessage = self::validateGivenNameForArrayConstraintsFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($givenNameMaxLengthErrorMessage = self::validateGivenNameForMaxLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($givenName) && count($givenName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($givenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($givenNameMinLengthErrorMessage = self::validateGivenNameForMinLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMinLengthErrorMessage, __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PayerIndividualType
     */
    public function addToGivenName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->GivenName) && count($this->GivenName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->GivenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get IndividualID value
     * @return string|null
     */
    public function getIndividualID()
    {
        return $this->IndividualID;
    }
    /**
     * Set IndividualID value
     * @param string $individualID
     * @return \StructType\PayerIndividualType
     */
    public function setIndividualID($individualID = null)
    {
        // validation for constraint: string
        if (!is_null($individualID) && !is_string($individualID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualID, true), gettype($individualID)), __LINE__);
        }
        $this->IndividualID = $individualID;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * This method is responsible for validating the values passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForArrayConstraintsFromSetMiddleName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payerIndividualTypeMiddleNameItem) {
            // validation for constraint: itemType
            if (!is_string($payerIndividualTypeMiddleNameItem)) {
                $invalidValues[] = is_object($payerIndividualTypeMiddleNameItem) ? get_class($payerIndividualTypeMiddleNameItem) : sprintf('%s(%s)', gettype($payerIndividualTypeMiddleNameItem), var_export($payerIndividualTypeMiddleNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiddleName property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMaxLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payerIndividualTypeMiddleNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($payerIndividualTypeMiddleNameItem) > 64) {
                $invalidValues[] = var_export($payerIndividualTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMinLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payerIndividualTypeMiddleNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($payerIndividualTypeMiddleNameItem) < 1) {
                $invalidValues[] = var_export($payerIndividualTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param string[] $middleName
     * @return \StructType\PayerIndividualType
     */
    public function setMiddleName(array $middleName = array())
    {
        // validation for constraint: array
        if ('' !== ($middleNameArrayErrorMessage = self::validateMiddleNameForArrayConstraintsFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($middleNameMaxLengthErrorMessage = self::validateMiddleNameForMaxLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($middleName) && count($middleName) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($middleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($middleNameMinLengthErrorMessage = self::validateMiddleNameForMinLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMinLengthErrorMessage, __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PayerIndividualType
     */
    public function addToMiddleName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->MiddleName) && count($this->MiddleName) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->MiddleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SuffixName value
     * @return string|null
     */
    public function getSuffixName()
    {
        return $this->SuffixName;
    }
    /**
     * Set SuffixName value
     * @param string $suffixName
     * @return \StructType\PayerIndividualType
     */
    public function setSuffixName($suffixName = null)
    {
        // validation for constraint: string
        if (!is_null($suffixName) && !is_string($suffixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffixName, true), gettype($suffixName)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($suffixName) && mb_strlen($suffixName) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($suffixName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($suffixName) && mb_strlen($suffixName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($suffixName)), __LINE__);
        }
        $this->SuffixName = $suffixName;
        return $this;
    }
    /**
     * Get TitleName value
     * @return string|null
     */
    public function getTitleName()
    {
        return $this->TitleName;
    }
    /**
     * Set TitleName value
     * @param string $titleName
     * @return \StructType\PayerIndividualType
     */
    public function setTitleName($titleName = null)
    {
        // validation for constraint: string
        if (!is_null($titleName) && !is_string($titleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleName, true), gettype($titleName)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($titleName) && mb_strlen($titleName) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($titleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($titleName) && mb_strlen($titleName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($titleName)), __LINE__);
        }
        $this->TitleName = $titleName;
        return $this;
    }
}
