<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
 * fulfillment.
 * @subpackage Structs
 */
class PaxType extends AbstractStructBase
{
    /**
     * The PaxID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxID;
    /**
     * The AgeMeasure
     * Meta information extracted from the WSDL
     * - documentation: The Age of the Passenger. To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $AgeMeasure;
    /**
     * The Birthdate
     * Meta information extracted from the WSDL
     * - documentation: The Date of Birth of the Passenger. Intended to be used in NDC Anonymous Shopping requests. Example: 2017-01-13 | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Birthdate;
    /**
     * The CitizenshipCountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CitizenshipCountryCode;
    /**
     * The ContactInfoRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a set of Contact Information, within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactInfoRefID;
    /**
     * The Employer
     * Meta information extracted from the WSDL
     * - documentation: An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EmployerType
     */
    public $Employer;
    /**
     * The FOID
     * Meta information extracted from the WSDL
     * - documentation: Form of identification. Typically used to identify that the passenger is who he says he is. This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FOID_Type
     */
    public $FOID;
    /**
     * The IdentityDoc
     * Meta information extracted from the WSDL
     * - documentation: Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity
     * documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID. In the absence of a formal identity document, a driver's license may be
     * accepted in many countries for identity verification. Most countries accept passports as a form of identification.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IdentityDocType[]
     */
    public $IdentityDoc;
    /**
     * The Individual
     * Meta information extracted from the WSDL
     * - documentation: A single human being as distinct from a group, class, or family.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IndividualType
     */
    public $Individual;
    /**
     * The LangUsage
     * Meta information extracted from the WSDL
     * - documentation: Language Code representation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LangUsageType[]
     */
    public $LangUsage;
    /**
     * The LoyaltyProgramAccount
     * Meta information extracted from the WSDL
     * - documentation: An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LoyaltyProgramAccountType[]
     */
    public $LoyaltyProgramAccount;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: For use from in-lap passenger instance, to reference the adult passenger with whom they are travelling. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is
     * managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * The ProfileConsentInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, passenger authorizes the airline to share his/her profile information or send promotional emails. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ProfileConsentInd;
    /**
     * The ProfileID_Text
     * Meta information extracted from the WSDL
     * - documentation: Passenger Profile ID | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileID_Text;
    /**
     * The PTC
     * Meta information extracted from the WSDL
     * - documentation: Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc). | Additional BDT to specify the type code codeset applying to a Passenger.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PTC;
    /**
     * The RedressCase
     * Meta information extracted from the WSDL
     * - documentation: A person's case of being registered with a country's redress program, which can eliminate watch list misidentification and assist in identity verification.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RedressCaseType[]
     */
    public $RedressCase;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * The ResidenceCountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $ResidenceCountryCode;
    /**
     * Constructor method for PaxType
     * @uses PaxType::setPaxID()
     * @uses PaxType::setAgeMeasure()
     * @uses PaxType::setBirthdate()
     * @uses PaxType::setCitizenshipCountryCode()
     * @uses PaxType::setContactInfoRefID()
     * @uses PaxType::setEmployer()
     * @uses PaxType::setFOID()
     * @uses PaxType::setIdentityDoc()
     * @uses PaxType::setIndividual()
     * @uses PaxType::setLangUsage()
     * @uses PaxType::setLoyaltyProgramAccount()
     * @uses PaxType::setPaxRefID()
     * @uses PaxType::setProfileConsentInd()
     * @uses PaxType::setProfileID_Text()
     * @uses PaxType::setPTC()
     * @uses PaxType::setRedressCase()
     * @uses PaxType::setRemark()
     * @uses PaxType::setResidenceCountryCode()
     * @param string $paxID
     * @param \StructType\MeasureType $ageMeasure
     * @param string $birthdate
     * @param string $citizenshipCountryCode
     * @param string $contactInfoRefID
     * @param \StructType\EmployerType $employer
     * @param \StructType\FOID_Type $fOID
     * @param \StructType\IdentityDocType[] $identityDoc
     * @param \StructType\IndividualType $individual
     * @param \StructType\LangUsageType[] $langUsage
     * @param \StructType\LoyaltyProgramAccountType[] $loyaltyProgramAccount
     * @param string $paxRefID
     * @param bool $profileConsentInd
     * @param string $profileID_Text
     * @param string $pTC
     * @param \StructType\RedressCaseType[] $redressCase
     * @param \StructType\RemarkType[] $remark
     * @param string $residenceCountryCode
     */
    public function __construct($paxID = null, \StructType\MeasureType $ageMeasure = null, $birthdate = null, $citizenshipCountryCode = null, $contactInfoRefID = null, \StructType\EmployerType $employer = null, \StructType\FOID_Type $fOID = null, array $identityDoc = array(), \StructType\IndividualType $individual = null, array $langUsage = array(), array $loyaltyProgramAccount = array(), $paxRefID = null, $profileConsentInd = null, $profileID_Text = null, $pTC = null, array $redressCase = array(), array $remark = array(), $residenceCountryCode = null)
    {
        $this
            ->setPaxID($paxID)
            ->setAgeMeasure($ageMeasure)
            ->setBirthdate($birthdate)
            ->setCitizenshipCountryCode($citizenshipCountryCode)
            ->setContactInfoRefID($contactInfoRefID)
            ->setEmployer($employer)
            ->setFOID($fOID)
            ->setIdentityDoc($identityDoc)
            ->setIndividual($individual)
            ->setLangUsage($langUsage)
            ->setLoyaltyProgramAccount($loyaltyProgramAccount)
            ->setPaxRefID($paxRefID)
            ->setProfileConsentInd($profileConsentInd)
            ->setProfileID_Text($profileID_Text)
            ->setPTC($pTC)
            ->setRedressCase($redressCase)
            ->setRemark($remark)
            ->setResidenceCountryCode($residenceCountryCode);
    }
    /**
     * Get PaxID value
     * @return string
     */
    public function getPaxID()
    {
        return $this->PaxID;
    }
    /**
     * Set PaxID value
     * @param string $paxID
     * @return \StructType\PaxType
     */
    public function setPaxID($paxID = null)
    {
        // validation for constraint: string
        if (!is_null($paxID) && !is_string($paxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxID, true), gettype($paxID)), __LINE__);
        }
        $this->PaxID = $paxID;
        return $this;
    }
    /**
     * Get AgeMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getAgeMeasure()
    {
        return $this->AgeMeasure;
    }
    /**
     * Set AgeMeasure value
     * @param \StructType\MeasureType $ageMeasure
     * @return \StructType\PaxType
     */
    public function setAgeMeasure(\StructType\MeasureType $ageMeasure = null)
    {
        $this->AgeMeasure = $ageMeasure;
        return $this;
    }
    /**
     * Get Birthdate value
     * @return string|null
     */
    public function getBirthdate()
    {
        return $this->Birthdate;
    }
    /**
     * Set Birthdate value
     * @param string $birthdate
     * @return \StructType\PaxType
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        $this->Birthdate = $birthdate;
        return $this;
    }
    /**
     * Get CitizenshipCountryCode value
     * @return string|null
     */
    public function getCitizenshipCountryCode()
    {
        return $this->CitizenshipCountryCode;
    }
    /**
     * Set CitizenshipCountryCode value
     * @param string $citizenshipCountryCode
     * @return \StructType\PaxType
     */
    public function setCitizenshipCountryCode($citizenshipCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($citizenshipCountryCode) && !is_string($citizenshipCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citizenshipCountryCode, true), gettype($citizenshipCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($citizenshipCountryCode) && !preg_match('/[A-Z]{2}/', $citizenshipCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($citizenshipCountryCode, true)), __LINE__);
        }
        $this->CitizenshipCountryCode = $citizenshipCountryCode;
        return $this;
    }
    /**
     * Get ContactInfoRefID value
     * @return string|null
     */
    public function getContactInfoRefID()
    {
        return $this->ContactInfoRefID;
    }
    /**
     * Set ContactInfoRefID value
     * @param string $contactInfoRefID
     * @return \StructType\PaxType
     */
    public function setContactInfoRefID($contactInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($contactInfoRefID) && !is_string($contactInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInfoRefID, true), gettype($contactInfoRefID)), __LINE__);
        }
        $this->ContactInfoRefID = $contactInfoRefID;
        return $this;
    }
    /**
     * Get Employer value
     * @return \StructType\EmployerType|null
     */
    public function getEmployer()
    {
        return $this->Employer;
    }
    /**
     * Set Employer value
     * @param \StructType\EmployerType $employer
     * @return \StructType\PaxType
     */
    public function setEmployer(\StructType\EmployerType $employer = null)
    {
        $this->Employer = $employer;
        return $this;
    }
    /**
     * Get FOID value
     * @return \StructType\FOID_Type|null
     */
    public function getFOID()
    {
        return $this->FOID;
    }
    /**
     * Set FOID value
     * @param \StructType\FOID_Type $fOID
     * @return \StructType\PaxType
     */
    public function setFOID(\StructType\FOID_Type $fOID = null)
    {
        $this->FOID = $fOID;
        return $this;
    }
    /**
     * Get IdentityDoc value
     * @return \StructType\IdentityDocType[]|null
     */
    public function getIdentityDoc()
    {
        return $this->IdentityDoc;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentityDoc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentityDoc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentityDocForArrayConstraintsFromSetIdentityDoc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxTypeIdentityDocItem) {
            // validation for constraint: itemType
            if (!$paxTypeIdentityDocItem instanceof \StructType\IdentityDocType) {
                $invalidValues[] = is_object($paxTypeIdentityDocItem) ? get_class($paxTypeIdentityDocItem) : sprintf('%s(%s)', gettype($paxTypeIdentityDocItem), var_export($paxTypeIdentityDocItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IdentityDoc property can only contain items of type \StructType\IdentityDocType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IdentityDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentityDocType[] $identityDoc
     * @return \StructType\PaxType
     */
    public function setIdentityDoc(array $identityDoc = array())
    {
        // validation for constraint: array
        if ('' !== ($identityDocArrayErrorMessage = self::validateIdentityDocForArrayConstraintsFromSetIdentityDoc($identityDoc))) {
            throw new \InvalidArgumentException($identityDocArrayErrorMessage, __LINE__);
        }
        $this->IdentityDoc = $identityDoc;
        return $this;
    }
    /**
     * Add item to IdentityDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentityDocType $item
     * @return \StructType\PaxType
     */
    public function addToIdentityDoc(\StructType\IdentityDocType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentityDocType) {
            throw new \InvalidArgumentException(sprintf('The IdentityDoc property can only contain items of type \StructType\IdentityDocType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IdentityDoc[] = $item;
        return $this;
    }
    /**
     * Get Individual value
     * @return \StructType\IndividualType|null
     */
    public function getIndividual()
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \StructType\IndividualType $individual
     * @return \StructType\PaxType
     */
    public function setIndividual(\StructType\IndividualType $individual = null)
    {
        $this->Individual = $individual;
        return $this;
    }
    /**
     * Get LangUsage value
     * @return \StructType\LangUsageType[]|null
     */
    public function getLangUsage()
    {
        return $this->LangUsage;
    }
    /**
     * This method is responsible for validating the values passed to the setLangUsage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLangUsage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLangUsageForArrayConstraintsFromSetLangUsage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxTypeLangUsageItem) {
            // validation for constraint: itemType
            if (!$paxTypeLangUsageItem instanceof \StructType\LangUsageType) {
                $invalidValues[] = is_object($paxTypeLangUsageItem) ? get_class($paxTypeLangUsageItem) : sprintf('%s(%s)', gettype($paxTypeLangUsageItem), var_export($paxTypeLangUsageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LangUsage property can only contain items of type \StructType\LangUsageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LangUsage value
     * @throws \InvalidArgumentException
     * @param \StructType\LangUsageType[] $langUsage
     * @return \StructType\PaxType
     */
    public function setLangUsage(array $langUsage = array())
    {
        // validation for constraint: array
        if ('' !== ($langUsageArrayErrorMessage = self::validateLangUsageForArrayConstraintsFromSetLangUsage($langUsage))) {
            throw new \InvalidArgumentException($langUsageArrayErrorMessage, __LINE__);
        }
        $this->LangUsage = $langUsage;
        return $this;
    }
    /**
     * Add item to LangUsage value
     * @throws \InvalidArgumentException
     * @param \StructType\LangUsageType $item
     * @return \StructType\PaxType
     */
    public function addToLangUsage(\StructType\LangUsageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LangUsageType) {
            throw new \InvalidArgumentException(sprintf('The LangUsage property can only contain items of type \StructType\LangUsageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LangUsage[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgramAccount value
     * @return \StructType\LoyaltyProgramAccountType[]|null
     */
    public function getLoyaltyProgramAccount()
    {
        return $this->LoyaltyProgramAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyProgramAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyProgramAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyProgramAccountForArrayConstraintsFromSetLoyaltyProgramAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxTypeLoyaltyProgramAccountItem) {
            // validation for constraint: itemType
            if (!$paxTypeLoyaltyProgramAccountItem instanceof \StructType\LoyaltyProgramAccountType) {
                $invalidValues[] = is_object($paxTypeLoyaltyProgramAccountItem) ? get_class($paxTypeLoyaltyProgramAccountItem) : sprintf('%s(%s)', gettype($paxTypeLoyaltyProgramAccountItem), var_export($paxTypeLoyaltyProgramAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyProgramAccount property can only contain items of type \StructType\LoyaltyProgramAccountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyProgramAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyProgramAccountType[] $loyaltyProgramAccount
     * @return \StructType\PaxType
     */
    public function setLoyaltyProgramAccount(array $loyaltyProgramAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyProgramAccountArrayErrorMessage = self::validateLoyaltyProgramAccountForArrayConstraintsFromSetLoyaltyProgramAccount($loyaltyProgramAccount))) {
            throw new \InvalidArgumentException($loyaltyProgramAccountArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyProgramAccount = $loyaltyProgramAccount;
        return $this;
    }
    /**
     * Add item to LoyaltyProgramAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyProgramAccountType $item
     * @return \StructType\PaxType
     */
    public function addToLoyaltyProgramAccount(\StructType\LoyaltyProgramAccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyProgramAccountType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgramAccount property can only contain items of type \StructType\LoyaltyProgramAccountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyProgramAccount[] = $item;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\PaxType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get ProfileConsentInd value
     * @return bool|null
     */
    public function getProfileConsentInd()
    {
        return $this->ProfileConsentInd;
    }
    /**
     * Set ProfileConsentInd value
     * @param bool $profileConsentInd
     * @return \StructType\PaxType
     */
    public function setProfileConsentInd($profileConsentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($profileConsentInd) && !is_bool($profileConsentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($profileConsentInd, true), gettype($profileConsentInd)), __LINE__);
        }
        $this->ProfileConsentInd = $profileConsentInd;
        return $this;
    }
    /**
     * Get ProfileID_Text value
     * @return string|null
     */
    public function getProfileID_Text()
    {
        return $this->ProfileID_Text;
    }
    /**
     * Set ProfileID_Text value
     * @param string $profileID_Text
     * @return \StructType\PaxType
     */
    public function setProfileID_Text($profileID_Text = null)
    {
        // validation for constraint: string
        if (!is_null($profileID_Text) && !is_string($profileID_Text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileID_Text, true), gettype($profileID_Text)), __LINE__);
        }
        $this->ProfileID_Text = $profileID_Text;
        return $this;
    }
    /**
     * Get PTC value
     * @return string|null
     */
    public function getPTC()
    {
        return $this->PTC;
    }
    /**
     * Set PTC value
     * @param string $pTC
     * @return \StructType\PaxType
     */
    public function setPTC($pTC = null)
    {
        // validation for constraint: string
        if (!is_null($pTC) && !is_string($pTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pTC, true), gettype($pTC)), __LINE__);
        }
        $this->PTC = $pTC;
        return $this;
    }
    /**
     * Get RedressCase value
     * @return \StructType\RedressCaseType[]|null
     */
    public function getRedressCase()
    {
        return $this->RedressCase;
    }
    /**
     * This method is responsible for validating the values passed to the setRedressCase method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRedressCase method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRedressCaseForArrayConstraintsFromSetRedressCase(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxTypeRedressCaseItem) {
            // validation for constraint: itemType
            if (!$paxTypeRedressCaseItem instanceof \StructType\RedressCaseType) {
                $invalidValues[] = is_object($paxTypeRedressCaseItem) ? get_class($paxTypeRedressCaseItem) : sprintf('%s(%s)', gettype($paxTypeRedressCaseItem), var_export($paxTypeRedressCaseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RedressCase property can only contain items of type \StructType\RedressCaseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RedressCase value
     * @throws \InvalidArgumentException
     * @param \StructType\RedressCaseType[] $redressCase
     * @return \StructType\PaxType
     */
    public function setRedressCase(array $redressCase = array())
    {
        // validation for constraint: array
        if ('' !== ($redressCaseArrayErrorMessage = self::validateRedressCaseForArrayConstraintsFromSetRedressCase($redressCase))) {
            throw new \InvalidArgumentException($redressCaseArrayErrorMessage, __LINE__);
        }
        $this->RedressCase = $redressCase;
        return $this;
    }
    /**
     * Add item to RedressCase value
     * @throws \InvalidArgumentException
     * @param \StructType\RedressCaseType $item
     * @return \StructType\PaxType
     */
    public function addToRedressCase(\StructType\RedressCaseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RedressCaseType) {
            throw new \InvalidArgumentException(sprintf('The RedressCase property can only contain items of type \StructType\RedressCaseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RedressCase[] = $item;
        return $this;
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$paxTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($paxTypeRemarkItem) ? get_class($paxTypeRemarkItem) : sprintf('%s(%s)', gettype($paxTypeRemarkItem), var_export($paxTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\PaxType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\PaxType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Get ResidenceCountryCode value
     * @return string|null
     */
    public function getResidenceCountryCode()
    {
        return $this->ResidenceCountryCode;
    }
    /**
     * Set ResidenceCountryCode value
     * @param string $residenceCountryCode
     * @return \StructType\PaxType
     */
    public function setResidenceCountryCode($residenceCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($residenceCountryCode) && !is_string($residenceCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenceCountryCode, true), gettype($residenceCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($residenceCountryCode) && !preg_match('/[A-Z]{2}/', $residenceCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($residenceCountryCode, true)), __LINE__);
        }
        $this->ResidenceCountryCode = $residenceCountryCode;
        return $this;
    }
}
