<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxSegmentRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to a PaxSegmentID . This will be a reference to a single passenger segment that will be defined in a data list or pax segment list in the contained message.
 * @subpackage Structs
 */
class PaxSegmentRefType extends AbstractStructBase
{
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxSegmentRefID;
    /**
     * Constructor method for PaxSegmentRefType
     * @uses PaxSegmentRefType::setPaxSegmentRefID()
     * @param string $paxSegmentRefID
     */
    public function __construct($paxSegmentRefID = null)
    {
        $this
            ->setPaxSegmentRefID($paxSegmentRefID);
    }
    /**
     * Get PaxSegmentRefID value
     * @return string
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * Set PaxSegmentRefID value
     * @param string $paxSegmentRefID
     * @return \StructType\PaxSegmentRefType
     */
    public function setPaxSegmentRefID($paxSegmentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxSegmentRefID) && !is_string($paxSegmentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxSegmentRefID, true), gettype($paxSegmentRefID)), __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
}
