<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxSegmentRefListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
 * @subpackage Structs
 */
class PaxSegmentRefListType extends AbstractStructBase
{
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $PaxSegmentRefID;
    /**
     * Constructor method for PaxSegmentRefListType
     * @uses PaxSegmentRefListType::setPaxSegmentRefID()
     * @param string[] $paxSegmentRefID
     */
    public function __construct(array $paxSegmentRefID = array())
    {
        $this
            ->setPaxSegmentRefID($paxSegmentRefID);
    }
    /**
     * Get PaxSegmentRefID value
     * @return string[]
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegmentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxSegmentRefListTypePaxSegmentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($paxSegmentRefListTypePaxSegmentRefIDItem)) {
                $invalidValues[] = is_object($paxSegmentRefListTypePaxSegmentRefIDItem) ? get_class($paxSegmentRefListTypePaxSegmentRefIDItem) : sprintf('%s(%s)', gettype($paxSegmentRefListTypePaxSegmentRefIDItem), var_export($paxSegmentRefListTypePaxSegmentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxSegmentRefID
     * @return \StructType\PaxSegmentRefListType
     */
    public function setPaxSegmentRefID(array $paxSegmentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentRefIDArrayErrorMessage = self::validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID($paxSegmentRefID))) {
            throw new \InvalidArgumentException($paxSegmentRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Add item to PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaxSegmentRefListType
     */
    public function addToPaxSegmentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegmentRefID[] = $item;
        return $this;
    }
}
