<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxJourneyType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of segments which satisfies transportation of a passenger for a given origin and destination. Business Identifier Fields: - (no identifier available)
 * @subpackage Structs
 */
class PaxJourneyType extends AbstractStructBase
{
    /**
     * The PaxJourneyID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Journey within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxJourneyID;
    /**
     * The PaxSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger Segment ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $PaxSegmentRefID;
    /**
     * The DistanceMeasure
     * Meta information extracted from the WSDL
     * - documentation: Total distance between the beginning and end stations of a leg, measured by the great circle of the earth.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $DistanceMeasure;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Total journey time including the combined air time and connection times. In case of stopover, this may or may not include stopover durations. | A duration is the specification of a length of time without a fixed start or end time,
     * expressed in Gregorian calendar time units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Duration;
    /**
     * The SettlementInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the value of a product or service as it pertains to interline transactions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SettlementInfoType
     */
    public $SettlementInfo;
    /**
     * Constructor method for PaxJourneyType
     * @uses PaxJourneyType::setPaxJourneyID()
     * @uses PaxJourneyType::setPaxSegmentRefID()
     * @uses PaxJourneyType::setDistanceMeasure()
     * @uses PaxJourneyType::setDuration()
     * @uses PaxJourneyType::setSettlementInfo()
     * @param string $paxJourneyID
     * @param string[] $paxSegmentRefID
     * @param \StructType\MeasureType $distanceMeasure
     * @param string $duration
     * @param \StructType\SettlementInfoType $settlementInfo
     */
    public function __construct($paxJourneyID = null, array $paxSegmentRefID = array(), \StructType\MeasureType $distanceMeasure = null, $duration = null, \StructType\SettlementInfoType $settlementInfo = null)
    {
        $this
            ->setPaxJourneyID($paxJourneyID)
            ->setPaxSegmentRefID($paxSegmentRefID)
            ->setDistanceMeasure($distanceMeasure)
            ->setDuration($duration)
            ->setSettlementInfo($settlementInfo);
    }
    /**
     * Get PaxJourneyID value
     * @return string
     */
    public function getPaxJourneyID()
    {
        return $this->PaxJourneyID;
    }
    /**
     * Set PaxJourneyID value
     * @param string $paxJourneyID
     * @return \StructType\PaxJourneyType
     */
    public function setPaxJourneyID($paxJourneyID = null)
    {
        // validation for constraint: string
        if (!is_null($paxJourneyID) && !is_string($paxJourneyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxJourneyID, true), gettype($paxJourneyID)), __LINE__);
        }
        $this->PaxJourneyID = $paxJourneyID;
        return $this;
    }
    /**
     * Get PaxSegmentRefID value
     * @return string[]
     */
    public function getPaxSegmentRefID()
    {
        return $this->PaxSegmentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxSegmentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxJourneyTypePaxSegmentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($paxJourneyTypePaxSegmentRefIDItem)) {
                $invalidValues[] = is_object($paxJourneyTypePaxSegmentRefIDItem) ? get_class($paxJourneyTypePaxSegmentRefIDItem) : sprintf('%s(%s)', gettype($paxJourneyTypePaxSegmentRefIDItem), var_export($paxJourneyTypePaxSegmentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxSegmentRefID
     * @return \StructType\PaxJourneyType
     */
    public function setPaxSegmentRefID(array $paxSegmentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxSegmentRefIDArrayErrorMessage = self::validatePaxSegmentRefIDForArrayConstraintsFromSetPaxSegmentRefID($paxSegmentRefID))) {
            throw new \InvalidArgumentException($paxSegmentRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxSegmentRefID = $paxSegmentRefID;
        return $this;
    }
    /**
     * Add item to PaxSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaxJourneyType
     */
    public function addToPaxSegmentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxSegmentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxSegmentRefID[] = $item;
        return $this;
    }
    /**
     * Get DistanceMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getDistanceMeasure()
    {
        return $this->DistanceMeasure;
    }
    /**
     * Set DistanceMeasure value
     * @param \StructType\MeasureType $distanceMeasure
     * @return \StructType\PaxJourneyType
     */
    public function setDistanceMeasure(\StructType\MeasureType $distanceMeasure = null)
    {
        $this->DistanceMeasure = $distanceMeasure;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\PaxJourneyType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get SettlementInfo value
     * @return \StructType\SettlementInfoType|null
     */
    public function getSettlementInfo()
    {
        return $this->SettlementInfo;
    }
    /**
     * Set SettlementInfo value
     * @param \StructType\SettlementInfoType $settlementInfo
     * @return \StructType\PaxJourneyType
     */
    public function setSettlementInfo(\StructType\SettlementInfoType $settlementInfo = null)
    {
        $this->SettlementInfo = $settlementInfo;
        return $this;
    }
}
