<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxJourneyRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of segments which satisfies transportation of a passenger for a given origin and destination. Business Identifier Fields: - (no identifier available)
 * @subpackage Structs
 */
class PaxJourneyRefType extends AbstractStructBase
{
    /**
     * The PaxJourneyRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Journey within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $PaxJourneyRefID;
    /**
     * Constructor method for PaxJourneyRefType
     * @uses PaxJourneyRefType::setPaxJourneyRefID()
     * @param string[] $paxJourneyRefID
     */
    public function __construct(array $paxJourneyRefID = array())
    {
        $this
            ->setPaxJourneyRefID($paxJourneyRefID);
    }
    /**
     * Get PaxJourneyRefID value
     * @return string[]
     */
    public function getPaxJourneyRefID()
    {
        return $this->PaxJourneyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxJourneyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxJourneyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxJourneyRefIDForArrayConstraintsFromSetPaxJourneyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxJourneyRefTypePaxJourneyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($paxJourneyRefTypePaxJourneyRefIDItem)) {
                $invalidValues[] = is_object($paxJourneyRefTypePaxJourneyRefIDItem) ? get_class($paxJourneyRefTypePaxJourneyRefIDItem) : sprintf('%s(%s)', gettype($paxJourneyRefTypePaxJourneyRefIDItem), var_export($paxJourneyRefTypePaxJourneyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxJourneyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxJourneyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxJourneyRefID
     * @return \StructType\PaxJourneyRefType
     */
    public function setPaxJourneyRefID(array $paxJourneyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxJourneyRefIDArrayErrorMessage = self::validatePaxJourneyRefIDForArrayConstraintsFromSetPaxJourneyRefID($paxJourneyRefID))) {
            throw new \InvalidArgumentException($paxJourneyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxJourneyRefID = $paxJourneyRefID;
        return $this;
    }
    /**
     * Add item to PaxJourneyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaxJourneyRefType
     */
    public function addToPaxJourneyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxJourneyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxJourneyRefID[] = $item;
        return $this;
    }
}
