<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxGroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
 * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
 * @subpackage Structs
 */
class PaxGroupType extends AbstractStructBase
{
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoType[]
     */
    public $ContactInfo;
    /**
     * The IntendedPaxQty
     * Meta information extracted from the WSDL
     * - documentation: Intended number of passengers for this Group. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $IntendedPaxQty;
    /**
     * The PaxGroupID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Passenger Group. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxGroupID;
    /**
     * The PaxGroupName
     * Meta information extracted from the WSDL
     * - documentation: The name of the group. | The name of the group type.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxGroupName;
    /**
     * Constructor method for PaxGroupType
     * @uses PaxGroupType::setContactInfo()
     * @uses PaxGroupType::setIntendedPaxQty()
     * @uses PaxGroupType::setPaxGroupID()
     * @uses PaxGroupType::setPaxGroupName()
     * @param \StructType\ContactInfoType[] $contactInfo
     * @param float $intendedPaxQty
     * @param string $paxGroupID
     * @param string $paxGroupName
     */
    public function __construct(array $contactInfo = array(), $intendedPaxQty = null, $paxGroupID = null, $paxGroupName = null)
    {
        $this
            ->setContactInfo($contactInfo)
            ->setIntendedPaxQty($intendedPaxQty)
            ->setPaxGroupID($paxGroupID)
            ->setPaxGroupName($paxGroupName);
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxGroupTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$paxGroupTypeContactInfoItem instanceof \StructType\ContactInfoType) {
                $invalidValues[] = is_object($paxGroupTypeContactInfoItem) ? get_class($paxGroupTypeContactInfoItem) : sprintf('%s(%s)', gettype($paxGroupTypeContactInfoItem), var_export($paxGroupTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType[] $contactInfo
     * @return \StructType\PaxGroupType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType $item
     * @return \StructType\PaxGroupType
     */
    public function addToContactInfo(\StructType\ContactInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
    /**
     * Get IntendedPaxQty value
     * @return float|null
     */
    public function getIntendedPaxQty()
    {
        return $this->IntendedPaxQty;
    }
    /**
     * Set IntendedPaxQty value
     * @param float $intendedPaxQty
     * @return \StructType\PaxGroupType
     */
    public function setIntendedPaxQty($intendedPaxQty = null)
    {
        // validation for constraint: float
        if (!is_null($intendedPaxQty) && !(is_float($intendedPaxQty) || is_numeric($intendedPaxQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($intendedPaxQty, true), gettype($intendedPaxQty)), __LINE__);
        }
        $this->IntendedPaxQty = $intendedPaxQty;
        return $this;
    }
    /**
     * Get PaxGroupID value
     * @return string|null
     */
    public function getPaxGroupID()
    {
        return $this->PaxGroupID;
    }
    /**
     * Set PaxGroupID value
     * @param string $paxGroupID
     * @return \StructType\PaxGroupType
     */
    public function setPaxGroupID($paxGroupID = null)
    {
        // validation for constraint: string
        if (!is_null($paxGroupID) && !is_string($paxGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxGroupID, true), gettype($paxGroupID)), __LINE__);
        }
        $this->PaxGroupID = $paxGroupID;
        return $this;
    }
    /**
     * Get PaxGroupName value
     * @return string|null
     */
    public function getPaxGroupName()
    {
        return $this->PaxGroupName;
    }
    /**
     * Set PaxGroupName value
     * @param string $paxGroupName
     * @return \StructType\PaxGroupType
     */
    public function setPaxGroupName($paxGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($paxGroupName) && !is_string($paxGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxGroupName, true), gettype($paxGroupName)), __LINE__);
        }
        $this->PaxGroupName = $paxGroupName;
        return $this;
    }
}
