<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
 * fulfillment.
 * @subpackage Structs
 */
class PaxFilterCriteriaType extends AbstractStructBase
{
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoType[]
     */
    public $ContactInfo;
    /**
     * The Employer
     * Meta information extracted from the WSDL
     * - documentation: An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EmployerType
     */
    public $Employer;
    /**
     * The FOID
     * Meta information extracted from the WSDL
     * - documentation: Form of identification. Typically used to identify that the passenger is who he says he is. This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FOID_Type
     */
    public $FOID;
    /**
     * The IdentityDoc
     * Meta information extracted from the WSDL
     * - documentation: Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity
     * documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID. In the absence of a formal identity document, a driver's license may be
     * accepted in many countries for identity verification. Most countries accept passports as a form of identification.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IdentityDocType[]
     */
    public $IdentityDoc;
    /**
     * The Individual
     * Meta information extracted from the WSDL
     * - documentation: A single human being as distinct from a group, class, or family.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IndividualType
     */
    public $Individual;
    /**
     * The LangUsage
     * Meta information extracted from the WSDL
     * - documentation: Language Code representation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LangUsageType[]
     */
    public $LangUsage;
    /**
     * The LoyaltyProgramAccount
     * Meta information extracted from the WSDL
     * - documentation: An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LoyaltyProgramAccountType[]
     */
    public $LoyaltyProgramAccount;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxGroupType
     */
    public $PaxGroup;
    /**
     * Constructor method for PaxFilterCriteriaType
     * @uses PaxFilterCriteriaType::setContactInfo()
     * @uses PaxFilterCriteriaType::setEmployer()
     * @uses PaxFilterCriteriaType::setFOID()
     * @uses PaxFilterCriteriaType::setIdentityDoc()
     * @uses PaxFilterCriteriaType::setIndividual()
     * @uses PaxFilterCriteriaType::setLangUsage()
     * @uses PaxFilterCriteriaType::setLoyaltyProgramAccount()
     * @uses PaxFilterCriteriaType::setPaxGroup()
     * @param \StructType\ContactInfoType[] $contactInfo
     * @param \StructType\EmployerType $employer
     * @param \StructType\FOID_Type $fOID
     * @param \StructType\IdentityDocType[] $identityDoc
     * @param \StructType\IndividualType $individual
     * @param \StructType\LangUsageType[] $langUsage
     * @param \StructType\LoyaltyProgramAccountType[] $loyaltyProgramAccount
     * @param \StructType\PaxGroupType $paxGroup
     */
    public function __construct(array $contactInfo = array(), \StructType\EmployerType $employer = null, \StructType\FOID_Type $fOID = null, array $identityDoc = array(), \StructType\IndividualType $individual = null, array $langUsage = array(), array $loyaltyProgramAccount = array(), \StructType\PaxGroupType $paxGroup = null)
    {
        $this
            ->setContactInfo($contactInfo)
            ->setEmployer($employer)
            ->setFOID($fOID)
            ->setIdentityDoc($identityDoc)
            ->setIndividual($individual)
            ->setLangUsage($langUsage)
            ->setLoyaltyProgramAccount($loyaltyProgramAccount)
            ->setPaxGroup($paxGroup);
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfoType[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxFilterCriteriaTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$paxFilterCriteriaTypeContactInfoItem instanceof \StructType\ContactInfoType) {
                $invalidValues[] = is_object($paxFilterCriteriaTypeContactInfoItem) ? get_class($paxFilterCriteriaTypeContactInfoItem) : sprintf('%s(%s)', gettype($paxFilterCriteriaTypeContactInfoItem), var_export($paxFilterCriteriaTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType[] $contactInfo
     * @return \StructType\PaxFilterCriteriaType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoType $item
     * @return \StructType\PaxFilterCriteriaType
     */
    public function addToContactInfo(\StructType\ContactInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
    /**
     * Get Employer value
     * @return \StructType\EmployerType|null
     */
    public function getEmployer()
    {
        return $this->Employer;
    }
    /**
     * Set Employer value
     * @param \StructType\EmployerType $employer
     * @return \StructType\PaxFilterCriteriaType
     */
    public function setEmployer(\StructType\EmployerType $employer = null)
    {
        $this->Employer = $employer;
        return $this;
    }
    /**
     * Get FOID value
     * @return \StructType\FOID_Type|null
     */
    public function getFOID()
    {
        return $this->FOID;
    }
    /**
     * Set FOID value
     * @param \StructType\FOID_Type $fOID
     * @return \StructType\PaxFilterCriteriaType
     */
    public function setFOID(\StructType\FOID_Type $fOID = null)
    {
        $this->FOID = $fOID;
        return $this;
    }
    /**
     * Get IdentityDoc value
     * @return \StructType\IdentityDocType[]|null
     */
    public function getIdentityDoc()
    {
        return $this->IdentityDoc;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentityDoc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentityDoc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentityDocForArrayConstraintsFromSetIdentityDoc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxFilterCriteriaTypeIdentityDocItem) {
            // validation for constraint: itemType
            if (!$paxFilterCriteriaTypeIdentityDocItem instanceof \StructType\IdentityDocType) {
                $invalidValues[] = is_object($paxFilterCriteriaTypeIdentityDocItem) ? get_class($paxFilterCriteriaTypeIdentityDocItem) : sprintf('%s(%s)', gettype($paxFilterCriteriaTypeIdentityDocItem), var_export($paxFilterCriteriaTypeIdentityDocItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IdentityDoc property can only contain items of type \StructType\IdentityDocType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IdentityDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentityDocType[] $identityDoc
     * @return \StructType\PaxFilterCriteriaType
     */
    public function setIdentityDoc(array $identityDoc = array())
    {
        // validation for constraint: array
        if ('' !== ($identityDocArrayErrorMessage = self::validateIdentityDocForArrayConstraintsFromSetIdentityDoc($identityDoc))) {
            throw new \InvalidArgumentException($identityDocArrayErrorMessage, __LINE__);
        }
        $this->IdentityDoc = $identityDoc;
        return $this;
    }
    /**
     * Add item to IdentityDoc value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentityDocType $item
     * @return \StructType\PaxFilterCriteriaType
     */
    public function addToIdentityDoc(\StructType\IdentityDocType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentityDocType) {
            throw new \InvalidArgumentException(sprintf('The IdentityDoc property can only contain items of type \StructType\IdentityDocType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->IdentityDoc[] = $item;
        return $this;
    }
    /**
     * Get Individual value
     * @return \StructType\IndividualType|null
     */
    public function getIndividual()
    {
        return $this->Individual;
    }
    /**
     * Set Individual value
     * @param \StructType\IndividualType $individual
     * @return \StructType\PaxFilterCriteriaType
     */
    public function setIndividual(\StructType\IndividualType $individual = null)
    {
        $this->Individual = $individual;
        return $this;
    }
    /**
     * Get LangUsage value
     * @return \StructType\LangUsageType[]|null
     */
    public function getLangUsage()
    {
        return $this->LangUsage;
    }
    /**
     * This method is responsible for validating the values passed to the setLangUsage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLangUsage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLangUsageForArrayConstraintsFromSetLangUsage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxFilterCriteriaTypeLangUsageItem) {
            // validation for constraint: itemType
            if (!$paxFilterCriteriaTypeLangUsageItem instanceof \StructType\LangUsageType) {
                $invalidValues[] = is_object($paxFilterCriteriaTypeLangUsageItem) ? get_class($paxFilterCriteriaTypeLangUsageItem) : sprintf('%s(%s)', gettype($paxFilterCriteriaTypeLangUsageItem), var_export($paxFilterCriteriaTypeLangUsageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LangUsage property can only contain items of type \StructType\LangUsageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LangUsage value
     * @throws \InvalidArgumentException
     * @param \StructType\LangUsageType[] $langUsage
     * @return \StructType\PaxFilterCriteriaType
     */
    public function setLangUsage(array $langUsage = array())
    {
        // validation for constraint: array
        if ('' !== ($langUsageArrayErrorMessage = self::validateLangUsageForArrayConstraintsFromSetLangUsage($langUsage))) {
            throw new \InvalidArgumentException($langUsageArrayErrorMessage, __LINE__);
        }
        $this->LangUsage = $langUsage;
        return $this;
    }
    /**
     * Add item to LangUsage value
     * @throws \InvalidArgumentException
     * @param \StructType\LangUsageType $item
     * @return \StructType\PaxFilterCriteriaType
     */
    public function addToLangUsage(\StructType\LangUsageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LangUsageType) {
            throw new \InvalidArgumentException(sprintf('The LangUsage property can only contain items of type \StructType\LangUsageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LangUsage[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgramAccount value
     * @return \StructType\LoyaltyProgramAccountType[]|null
     */
    public function getLoyaltyProgramAccount()
    {
        return $this->LoyaltyProgramAccount;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyProgramAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyProgramAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyProgramAccountForArrayConstraintsFromSetLoyaltyProgramAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxFilterCriteriaTypeLoyaltyProgramAccountItem) {
            // validation for constraint: itemType
            if (!$paxFilterCriteriaTypeLoyaltyProgramAccountItem instanceof \StructType\LoyaltyProgramAccountType) {
                $invalidValues[] = is_object($paxFilterCriteriaTypeLoyaltyProgramAccountItem) ? get_class($paxFilterCriteriaTypeLoyaltyProgramAccountItem) : sprintf('%s(%s)', gettype($paxFilterCriteriaTypeLoyaltyProgramAccountItem), var_export($paxFilterCriteriaTypeLoyaltyProgramAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyProgramAccount property can only contain items of type \StructType\LoyaltyProgramAccountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyProgramAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyProgramAccountType[] $loyaltyProgramAccount
     * @return \StructType\PaxFilterCriteriaType
     */
    public function setLoyaltyProgramAccount(array $loyaltyProgramAccount = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyProgramAccountArrayErrorMessage = self::validateLoyaltyProgramAccountForArrayConstraintsFromSetLoyaltyProgramAccount($loyaltyProgramAccount))) {
            throw new \InvalidArgumentException($loyaltyProgramAccountArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyProgramAccount = $loyaltyProgramAccount;
        return $this;
    }
    /**
     * Add item to LoyaltyProgramAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyProgramAccountType $item
     * @return \StructType\PaxFilterCriteriaType
     */
    public function addToLoyaltyProgramAccount(\StructType\LoyaltyProgramAccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyProgramAccountType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgramAccount property can only contain items of type \StructType\LoyaltyProgramAccountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyProgramAccount[] = $item;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * Set PaxGroup value
     * @param \StructType\PaxGroupType $paxGroup
     * @return \StructType\PaxFilterCriteriaType
     */
    public function setPaxGroup(\StructType\PaxGroupType $paxGroup = null)
    {
        $this->PaxGroup = $paxGroup;
        return $this;
    }
}
