<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParticipatingOrgType StructType
 * Meta information extracted from the WSDL
 * - documentation: An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
 * @subpackage Structs
 */
class ParticipatingOrgType extends AbstractStructBase
{
    /**
     * The OrgID
     * Meta information extracted from the WSDL
     * - documentation: Organization code or identifier. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrgID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the organization | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for ParticipatingOrgType
     * @uses ParticipatingOrgType::setOrgID()
     * @uses ParticipatingOrgType::setName()
     * @param string $orgID
     * @param string $name
     */
    public function __construct($orgID = null, $name = null)
    {
        $this
            ->setOrgID($orgID)
            ->setName($name);
    }
    /**
     * Get OrgID value
     * @return string
     */
    public function getOrgID()
    {
        return $this->OrgID;
    }
    /**
     * Set OrgID value
     * @param string $orgID
     * @return \StructType\ParticipatingOrgType
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: string
        if (!is_null($orgID) && !is_string($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgID, true), gettype($orgID)), __LINE__);
        }
        $this->OrgID = $orgID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ParticipatingOrgType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
