<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherPaymentMethodType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information relating to non-standard forms of payment which may be used in exchange for goods or services.
 * @subpackage Structs
 */
class OtherPaymentMethodType extends AbstractStructBase
{
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Supplementary information.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\RemarkType[]
     */
    public $Remark;
    /**
     * Constructor method for OtherPaymentMethodType
     * @uses OtherPaymentMethodType::setRemark()
     * @param \StructType\RemarkType[] $remark
     */
    public function __construct(array $remark = array())
    {
        $this
            ->setRemark($remark);
    }
    /**
     * Get Remark value
     * @return \StructType\RemarkType[]
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * This method is responsible for validating the values passed to the setRemark method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemark method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkForArrayConstraintsFromSetRemark(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherPaymentMethodTypeRemarkItem) {
            // validation for constraint: itemType
            if (!$otherPaymentMethodTypeRemarkItem instanceof \StructType\RemarkType) {
                $invalidValues[] = is_object($otherPaymentMethodTypeRemarkItem) ? get_class($otherPaymentMethodTypeRemarkItem) : sprintf('%s(%s)', gettype($otherPaymentMethodTypeRemarkItem), var_export($otherPaymentMethodTypeRemarkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType[] $remark
     * @return \StructType\OtherPaymentMethodType
     */
    public function setRemark(array $remark = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkArrayErrorMessage = self::validateRemarkForArrayConstraintsFromSetRemark($remark))) {
            throw new \InvalidArgumentException($remarkArrayErrorMessage, __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \StructType\RemarkType $item
     * @return \StructType\OtherPaymentMethodType
     */
    public function addToRemark(\StructType\RemarkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RemarkType) {
            throw new \InvalidArgumentException(sprintf('The Remark property can only contain items of type \StructType\RemarkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Remark[] = $item;
        return $this;
    }
}
