<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherAddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: Other Contact Method information. E.g. web site URL, social media handle.
 * @subpackage Structs
 */
class OtherAddressType extends AbstractStructBase
{
    /**
     * The OtherAddressText
     * Meta information extracted from the WSDL
     * - documentation: Other Contact Method Value. Example: www.marketingsite.com | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OtherAddressText;
    /**
     * The ContactTypeText
     * Meta information extracted from the WSDL
     * - documentation: PADIS code list: Contact Type (to identify the technical contact type information) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactTypeText;
    /**
     * Constructor method for OtherAddressType
     * @uses OtherAddressType::setOtherAddressText()
     * @uses OtherAddressType::setContactTypeText()
     * @param string $otherAddressText
     * @param string $contactTypeText
     */
    public function __construct($otherAddressText = null, $contactTypeText = null)
    {
        $this
            ->setOtherAddressText($otherAddressText)
            ->setContactTypeText($contactTypeText);
    }
    /**
     * Get OtherAddressText value
     * @return string
     */
    public function getOtherAddressText()
    {
        return $this->OtherAddressText;
    }
    /**
     * Set OtherAddressText value
     * @param string $otherAddressText
     * @return \StructType\OtherAddressType
     */
    public function setOtherAddressText($otherAddressText = null)
    {
        // validation for constraint: string
        if (!is_null($otherAddressText) && !is_string($otherAddressText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherAddressText, true), gettype($otherAddressText)), __LINE__);
        }
        $this->OtherAddressText = $otherAddressText;
        return $this;
    }
    /**
     * Get ContactTypeText value
     * @return string|null
     */
    public function getContactTypeText()
    {
        return $this->ContactTypeText;
    }
    /**
     * Set ContactTypeText value
     * @param string $contactTypeText
     * @return \StructType\OtherAddressType
     */
    public function setContactTypeText($contactTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($contactTypeText) && !is_string($contactTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTypeText, true), gettype($contactTypeText)), __LINE__);
        }
        $this->ContactTypeText = $contactTypeText;
        return $this;
    }
}
