<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderViewResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the response.
 * @subpackage Structs
 */
class OrderViewResponseType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OrderedOrderType[]
     */
    public $Order;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataListsType
     */
    public $DataLists;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The Processing
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersResponseType
     */
    public $Processing;
    /**
     * The PromotionList
     * Meta information extracted from the WSDL
     * - documentation: Information related to publicizing a product, organization, or venture so as to increase sales or public awareness.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PromotionListType
     */
    public $PromotionList;
    /**
     * The TicketDocInfo
     * Meta information extracted from the WSDL
     * - documentation: Information corresponding to a group of 1 to 4 Tickets for a single Origin Destination and a single Passenger.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TicketDocInfoType[]
     */
    public $TicketDocInfo;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for OrderViewResponseType
     * @uses OrderViewResponseType::setOrder()
     * @uses OrderViewResponseType::setDataLists()
     * @uses OrderViewResponseType::setMetadata()
     * @uses OrderViewResponseType::setProcessing()
     * @uses OrderViewResponseType::setPromotionList()
     * @uses OrderViewResponseType::setTicketDocInfo()
     * @uses OrderViewResponseType::setWarning()
     * @param \StructType\OrderedOrderType[] $order
     * @param \StructType\DataListsType $dataLists
     * @param \StructType\MetadataType $metadata
     * @param \StructType\ResponseParametersResponseType $processing
     * @param \StructType\PromotionListType $promotionList
     * @param \StructType\TicketDocInfoType[] $ticketDocInfo
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(array $order = array(), \StructType\DataListsType $dataLists = null, \StructType\MetadataType $metadata = null, \StructType\ResponseParametersResponseType $processing = null, \StructType\PromotionListType $promotionList = null, array $ticketDocInfo = array(), array $warning = array())
    {
        $this
            ->setOrder($order)
            ->setDataLists($dataLists)
            ->setMetadata($metadata)
            ->setProcessing($processing)
            ->setPromotionList($promotionList)
            ->setTicketDocInfo($ticketDocInfo)
            ->setWarning($warning);
    }
    /**
     * Get Order value
     * @return \StructType\OrderedOrderType[]
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderViewResponseTypeOrderItem) {
            // validation for constraint: itemType
            if (!$orderViewResponseTypeOrderItem instanceof \StructType\OrderedOrderType) {
                $invalidValues[] = is_object($orderViewResponseTypeOrderItem) ? get_class($orderViewResponseTypeOrderItem) : sprintf('%s(%s)', gettype($orderViewResponseTypeOrderItem), var_export($orderViewResponseTypeOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order property can only contain items of type \StructType\OrderedOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderedOrderType[] $order
     * @return \StructType\OrderViewResponseType
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderedOrderType $item
     * @return \StructType\OrderViewResponseType
     */
    public function addToOrder(\StructType\OrderedOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderedOrderType) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of type \StructType\OrderedOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\DataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\DataListsType $dataLists
     * @return \StructType\OrderViewResponseType
     */
    public function setDataLists(\StructType\DataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\OrderViewResponseType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get Processing value
     * @return \StructType\ResponseParametersResponseType|null
     */
    public function getProcessing()
    {
        return $this->Processing;
    }
    /**
     * Set Processing value
     * @param \StructType\ResponseParametersResponseType $processing
     * @return \StructType\OrderViewResponseType
     */
    public function setProcessing(\StructType\ResponseParametersResponseType $processing = null)
    {
        $this->Processing = $processing;
        return $this;
    }
    /**
     * Get PromotionList value
     * @return \StructType\PromotionListType|null
     */
    public function getPromotionList()
    {
        return $this->PromotionList;
    }
    /**
     * Set PromotionList value
     * @param \StructType\PromotionListType $promotionList
     * @return \StructType\OrderViewResponseType
     */
    public function setPromotionList(\StructType\PromotionListType $promotionList = null)
    {
        $this->PromotionList = $promotionList;
        return $this;
    }
    /**
     * Get TicketDocInfo value
     * @return \StructType\TicketDocInfoType[]|null
     */
    public function getTicketDocInfo()
    {
        return $this->TicketDocInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDocInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDocInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDocInfoForArrayConstraintsFromSetTicketDocInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderViewResponseTypeTicketDocInfoItem) {
            // validation for constraint: itemType
            if (!$orderViewResponseTypeTicketDocInfoItem instanceof \StructType\TicketDocInfoType) {
                $invalidValues[] = is_object($orderViewResponseTypeTicketDocInfoItem) ? get_class($orderViewResponseTypeTicketDocInfoItem) : sprintf('%s(%s)', gettype($orderViewResponseTypeTicketDocInfoItem), var_export($orderViewResponseTypeTicketDocInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDocInfo property can only contain items of type \StructType\TicketDocInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDocInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocInfoType[] $ticketDocInfo
     * @return \StructType\OrderViewResponseType
     */
    public function setTicketDocInfo(array $ticketDocInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDocInfoArrayErrorMessage = self::validateTicketDocInfoForArrayConstraintsFromSetTicketDocInfo($ticketDocInfo))) {
            throw new \InvalidArgumentException($ticketDocInfoArrayErrorMessage, __LINE__);
        }
        $this->TicketDocInfo = $ticketDocInfo;
        return $this;
    }
    /**
     * Add item to TicketDocInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDocInfoType $item
     * @return \StructType\OrderViewResponseType
     */
    public function addToTicketDocInfo(\StructType\TicketDocInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDocInfoType) {
            throw new \InvalidArgumentException(sprintf('The TicketDocInfo property can only contain items of type \StructType\TicketDocInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketDocInfo[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderViewResponseTypeWarningItem) {
            // validation for constraint: itemType
            if (!$orderViewResponseTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($orderViewResponseTypeWarningItem) ? get_class($orderViewResponseTypeWarningItem) : sprintf('%s(%s)', gettype($orderViewResponseTypeWarningItem), var_export($orderViewResponseTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\OrderViewResponseType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\OrderViewResponseType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
