<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderValidationFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Order Validation filter criteria.
 * @subpackage Structs
 */
class OrderValidationFilterCriteriaType extends AbstractStructBase
{
    /**
     * The BookingRefFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Information related to booking or reservation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingInfoType
     */
    public $BookingRefFilterCriteria;
    /**
     * The DocFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: A Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountableDocType
     */
    public $DocFilterCriteria;
    /**
     * The OrderFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderFilterCriteriaType
     */
    public $OrderFilterCriteria;
    /**
     * The PaxFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxFilterCriteriaType
     */
    public $PaxFilterCriteria;
    /**
     * The PaymentFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: search filter by payment types
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFilterCriteriaType[]
     */
    public $PaymentFilterCriteria;
    /**
     * Constructor method for OrderValidationFilterCriteriaType
     * @uses OrderValidationFilterCriteriaType::setBookingRefFilterCriteria()
     * @uses OrderValidationFilterCriteriaType::setDocFilterCriteria()
     * @uses OrderValidationFilterCriteriaType::setOrderFilterCriteria()
     * @uses OrderValidationFilterCriteriaType::setPaxFilterCriteria()
     * @uses OrderValidationFilterCriteriaType::setPaymentFilterCriteria()
     * @param \StructType\BookingInfoType $bookingRefFilterCriteria
     * @param \StructType\AccountableDocType $docFilterCriteria
     * @param \StructType\OrderFilterCriteriaType $orderFilterCriteria
     * @param \StructType\PaxFilterCriteriaType $paxFilterCriteria
     * @param \StructType\PaymentFilterCriteriaType[] $paymentFilterCriteria
     */
    public function __construct(\StructType\BookingInfoType $bookingRefFilterCriteria = null, \StructType\AccountableDocType $docFilterCriteria = null, \StructType\OrderFilterCriteriaType $orderFilterCriteria = null, \StructType\PaxFilterCriteriaType $paxFilterCriteria = null, array $paymentFilterCriteria = array())
    {
        $this
            ->setBookingRefFilterCriteria($bookingRefFilterCriteria)
            ->setDocFilterCriteria($docFilterCriteria)
            ->setOrderFilterCriteria($orderFilterCriteria)
            ->setPaxFilterCriteria($paxFilterCriteria)
            ->setPaymentFilterCriteria($paymentFilterCriteria);
    }
    /**
     * Get BookingRefFilterCriteria value
     * @return \StructType\BookingInfoType|null
     */
    public function getBookingRefFilterCriteria()
    {
        return $this->BookingRefFilterCriteria;
    }
    /**
     * Set BookingRefFilterCriteria value
     * @param \StructType\BookingInfoType $bookingRefFilterCriteria
     * @return \StructType\OrderValidationFilterCriteriaType
     */
    public function setBookingRefFilterCriteria(\StructType\BookingInfoType $bookingRefFilterCriteria = null)
    {
        $this->BookingRefFilterCriteria = $bookingRefFilterCriteria;
        return $this;
    }
    /**
     * Get DocFilterCriteria value
     * @return \StructType\AccountableDocType|null
     */
    public function getDocFilterCriteria()
    {
        return $this->DocFilterCriteria;
    }
    /**
     * Set DocFilterCriteria value
     * @param \StructType\AccountableDocType $docFilterCriteria
     * @return \StructType\OrderValidationFilterCriteriaType
     */
    public function setDocFilterCriteria(\StructType\AccountableDocType $docFilterCriteria = null)
    {
        $this->DocFilterCriteria = $docFilterCriteria;
        return $this;
    }
    /**
     * Get OrderFilterCriteria value
     * @return \StructType\OrderFilterCriteriaType|null
     */
    public function getOrderFilterCriteria()
    {
        return $this->OrderFilterCriteria;
    }
    /**
     * Set OrderFilterCriteria value
     * @param \StructType\OrderFilterCriteriaType $orderFilterCriteria
     * @return \StructType\OrderValidationFilterCriteriaType
     */
    public function setOrderFilterCriteria(\StructType\OrderFilterCriteriaType $orderFilterCriteria = null)
    {
        $this->OrderFilterCriteria = $orderFilterCriteria;
        return $this;
    }
    /**
     * Get PaxFilterCriteria value
     * @return \StructType\PaxFilterCriteriaType|null
     */
    public function getPaxFilterCriteria()
    {
        return $this->PaxFilterCriteria;
    }
    /**
     * Set PaxFilterCriteria value
     * @param \StructType\PaxFilterCriteriaType $paxFilterCriteria
     * @return \StructType\OrderValidationFilterCriteriaType
     */
    public function setPaxFilterCriteria(\StructType\PaxFilterCriteriaType $paxFilterCriteria = null)
    {
        $this->PaxFilterCriteria = $paxFilterCriteria;
        return $this;
    }
    /**
     * Get PaymentFilterCriteria value
     * @return \StructType\PaymentFilterCriteriaType[]|null
     */
    public function getPaymentFilterCriteria()
    {
        return $this->PaymentFilterCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFilterCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFilterCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFilterCriteriaForArrayConstraintsFromSetPaymentFilterCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderValidationFilterCriteriaTypePaymentFilterCriteriaItem) {
            // validation for constraint: itemType
            if (!$orderValidationFilterCriteriaTypePaymentFilterCriteriaItem instanceof \StructType\PaymentFilterCriteriaType) {
                $invalidValues[] = is_object($orderValidationFilterCriteriaTypePaymentFilterCriteriaItem) ? get_class($orderValidationFilterCriteriaTypePaymentFilterCriteriaItem) : sprintf('%s(%s)', gettype($orderValidationFilterCriteriaTypePaymentFilterCriteriaItem), var_export($orderValidationFilterCriteriaTypePaymentFilterCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFilterCriteria property can only contain items of type \StructType\PaymentFilterCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFilterCriteriaType[] $paymentFilterCriteria
     * @return \StructType\OrderValidationFilterCriteriaType
     */
    public function setPaymentFilterCriteria(array $paymentFilterCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFilterCriteriaArrayErrorMessage = self::validatePaymentFilterCriteriaForArrayConstraintsFromSetPaymentFilterCriteria($paymentFilterCriteria))) {
            throw new \InvalidArgumentException($paymentFilterCriteriaArrayErrorMessage, __LINE__);
        }
        $this->PaymentFilterCriteria = $paymentFilterCriteria;
        return $this;
    }
    /**
     * Add item to PaymentFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFilterCriteriaType $item
     * @return \StructType\OrderValidationFilterCriteriaType
     */
    public function addToPaymentFilterCriteria(\StructType\PaymentFilterCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFilterCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFilterCriteria property can only contain items of type \StructType\PaymentFilterCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFilterCriteria[] = $item;
        return $this;
    }
}
