<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderServiceDefinitionRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
 * @subpackage Structs
 */
class OrderServiceDefinitionRefType extends AbstractStructBase
{
    /**
     * The ServiceDefinitionRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Service Definition ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceDefinitionRefID;
    /**
     * The OrderFlightAssociations
     * Meta information extracted from the WSDL
     * - documentation: Order Service Definition Ref Flight Associations
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderFlightAssociationsType
     */
    public $OrderFlightAssociations;
    /**
     * Constructor method for OrderServiceDefinitionRefType
     * @uses OrderServiceDefinitionRefType::setServiceDefinitionRefID()
     * @uses OrderServiceDefinitionRefType::setOrderFlightAssociations()
     * @param string $serviceDefinitionRefID
     * @param \StructType\OrderFlightAssociationsType $orderFlightAssociations
     */
    public function __construct($serviceDefinitionRefID = null, \StructType\OrderFlightAssociationsType $orderFlightAssociations = null)
    {
        $this
            ->setServiceDefinitionRefID($serviceDefinitionRefID)
            ->setOrderFlightAssociations($orderFlightAssociations);
    }
    /**
     * Get ServiceDefinitionRefID value
     * @return string
     */
    public function getServiceDefinitionRefID()
    {
        return $this->ServiceDefinitionRefID;
    }
    /**
     * Set ServiceDefinitionRefID value
     * @param string $serviceDefinitionRefID
     * @return \StructType\OrderServiceDefinitionRefType
     */
    public function setServiceDefinitionRefID($serviceDefinitionRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDefinitionRefID) && !is_string($serviceDefinitionRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDefinitionRefID, true), gettype($serviceDefinitionRefID)), __LINE__);
        }
        $this->ServiceDefinitionRefID = $serviceDefinitionRefID;
        return $this;
    }
    /**
     * Get OrderFlightAssociations value
     * @return \StructType\OrderFlightAssociationsType|null
     */
    public function getOrderFlightAssociations()
    {
        return $this->OrderFlightAssociations;
    }
    /**
     * Set OrderFlightAssociations value
     * @param \StructType\OrderFlightAssociationsType $orderFlightAssociations
     * @return \StructType\OrderServiceDefinitionRefType
     */
    public function setOrderFlightAssociations(\StructType\OrderFlightAssociationsType $orderFlightAssociations = null)
    {
        $this->OrderFlightAssociations = $orderFlightAssociations;
        return $this;
    }
}
