<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderSearchFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Order list request filter criteria.
 * @subpackage Structs
 */
class OrderSearchFilterCriteriaType extends AbstractStructBase
{
    /**
     * The BookingRefFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingRefType
     */
    public $BookingRefFilterCriteria;
    /**
     * The CarrierFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $CarrierFilterCriteria;
    /**
     * The CreationDateTimeFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Date range used to filter responses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeType
     */
    public $CreationDateTimeFilterCriteria;
    /**
     * The DocFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: A Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountableDocType
     */
    public $DocFilterCriteria;
    /**
     * The FlightFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Filters based on Flight Number, Origin Destination, Segment, or Departure/Arrival.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FlightFilterCriteriaType
     */
    public $FlightFilterCriteria;
    /**
     * The LastModifiedDateTimeFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Date range used to filter responses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeType
     */
    public $LastModifiedDateTimeFilterCriteria;
    /**
     * The OrderCancellationDateFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Date range information for filter criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateRangeType
     */
    public $OrderCancellationDateFilterCriteria;
    /**
     * The PaxFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxFilterCriteriaType
     */
    public $PaxFilterCriteria;
    /**
     * The PaxGroupFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxGroupType
     */
    public $PaxGroupFilterCriteria;
    /**
     * The PaymentFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: search filter by payment types
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFilterCriteriaType[]
     */
    public $PaymentFilterCriteria;
    /**
     * The ServiceFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Service filter criteria specialization of the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping,
     * a service can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceFilterCriteriaType
     */
    public $ServiceFilterCriteria;
    /**
     * The TicketFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: This is a specialization of the ticket class for use has filter criteria base definition: The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TicketFilterCriteriaType
     */
    public $TicketFilterCriteria;
    /**
     * The TravelDateFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Date range information for filter criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateRangeType
     */
    public $TravelDateFilterCriteria;
    /**
     * Constructor method for OrderSearchFilterCriteriaType
     * @uses OrderSearchFilterCriteriaType::setBookingRefFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setCarrierFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setCreationDateTimeFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setDocFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setFlightFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setLastModifiedDateTimeFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setOrderCancellationDateFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setPaxFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setPaxGroupFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setPaymentFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setServiceFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setTicketFilterCriteria()
     * @uses OrderSearchFilterCriteriaType::setTravelDateFilterCriteria()
     * @param \StructType\BookingRefType $bookingRefFilterCriteria
     * @param \StructType\CarrierType $carrierFilterCriteria
     * @param \StructType\DateTimeRangeType $creationDateTimeFilterCriteria
     * @param \StructType\AccountableDocType $docFilterCriteria
     * @param \StructType\FlightFilterCriteriaType $flightFilterCriteria
     * @param \StructType\DateTimeRangeType $lastModifiedDateTimeFilterCriteria
     * @param \StructType\DateRangeType $orderCancellationDateFilterCriteria
     * @param \StructType\PaxFilterCriteriaType $paxFilterCriteria
     * @param \StructType\PaxGroupType $paxGroupFilterCriteria
     * @param \StructType\PaymentFilterCriteriaType[] $paymentFilterCriteria
     * @param \StructType\ServiceFilterCriteriaType $serviceFilterCriteria
     * @param \StructType\TicketFilterCriteriaType $ticketFilterCriteria
     * @param \StructType\DateRangeType $travelDateFilterCriteria
     */
    public function __construct(\StructType\BookingRefType $bookingRefFilterCriteria = null, \StructType\CarrierType $carrierFilterCriteria = null, \StructType\DateTimeRangeType $creationDateTimeFilterCriteria = null, \StructType\AccountableDocType $docFilterCriteria = null, \StructType\FlightFilterCriteriaType $flightFilterCriteria = null, \StructType\DateTimeRangeType $lastModifiedDateTimeFilterCriteria = null, \StructType\DateRangeType $orderCancellationDateFilterCriteria = null, \StructType\PaxFilterCriteriaType $paxFilterCriteria = null, \StructType\PaxGroupType $paxGroupFilterCriteria = null, array $paymentFilterCriteria = array(), \StructType\ServiceFilterCriteriaType $serviceFilterCriteria = null, \StructType\TicketFilterCriteriaType $ticketFilterCriteria = null, \StructType\DateRangeType $travelDateFilterCriteria = null)
    {
        $this
            ->setBookingRefFilterCriteria($bookingRefFilterCriteria)
            ->setCarrierFilterCriteria($carrierFilterCriteria)
            ->setCreationDateTimeFilterCriteria($creationDateTimeFilterCriteria)
            ->setDocFilterCriteria($docFilterCriteria)
            ->setFlightFilterCriteria($flightFilterCriteria)
            ->setLastModifiedDateTimeFilterCriteria($lastModifiedDateTimeFilterCriteria)
            ->setOrderCancellationDateFilterCriteria($orderCancellationDateFilterCriteria)
            ->setPaxFilterCriteria($paxFilterCriteria)
            ->setPaxGroupFilterCriteria($paxGroupFilterCriteria)
            ->setPaymentFilterCriteria($paymentFilterCriteria)
            ->setServiceFilterCriteria($serviceFilterCriteria)
            ->setTicketFilterCriteria($ticketFilterCriteria)
            ->setTravelDateFilterCriteria($travelDateFilterCriteria);
    }
    /**
     * Get BookingRefFilterCriteria value
     * @return \StructType\BookingRefType|null
     */
    public function getBookingRefFilterCriteria()
    {
        return $this->BookingRefFilterCriteria;
    }
    /**
     * Set BookingRefFilterCriteria value
     * @param \StructType\BookingRefType $bookingRefFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setBookingRefFilterCriteria(\StructType\BookingRefType $bookingRefFilterCriteria = null)
    {
        $this->BookingRefFilterCriteria = $bookingRefFilterCriteria;
        return $this;
    }
    /**
     * Get CarrierFilterCriteria value
     * @return \StructType\CarrierType|null
     */
    public function getCarrierFilterCriteria()
    {
        return $this->CarrierFilterCriteria;
    }
    /**
     * Set CarrierFilterCriteria value
     * @param \StructType\CarrierType $carrierFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setCarrierFilterCriteria(\StructType\CarrierType $carrierFilterCriteria = null)
    {
        $this->CarrierFilterCriteria = $carrierFilterCriteria;
        return $this;
    }
    /**
     * Get CreationDateTimeFilterCriteria value
     * @return \StructType\DateTimeRangeType|null
     */
    public function getCreationDateTimeFilterCriteria()
    {
        return $this->CreationDateTimeFilterCriteria;
    }
    /**
     * Set CreationDateTimeFilterCriteria value
     * @param \StructType\DateTimeRangeType $creationDateTimeFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setCreationDateTimeFilterCriteria(\StructType\DateTimeRangeType $creationDateTimeFilterCriteria = null)
    {
        $this->CreationDateTimeFilterCriteria = $creationDateTimeFilterCriteria;
        return $this;
    }
    /**
     * Get DocFilterCriteria value
     * @return \StructType\AccountableDocType|null
     */
    public function getDocFilterCriteria()
    {
        return $this->DocFilterCriteria;
    }
    /**
     * Set DocFilterCriteria value
     * @param \StructType\AccountableDocType $docFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setDocFilterCriteria(\StructType\AccountableDocType $docFilterCriteria = null)
    {
        $this->DocFilterCriteria = $docFilterCriteria;
        return $this;
    }
    /**
     * Get FlightFilterCriteria value
     * @return \StructType\FlightFilterCriteriaType|null
     */
    public function getFlightFilterCriteria()
    {
        return $this->FlightFilterCriteria;
    }
    /**
     * Set FlightFilterCriteria value
     * @param \StructType\FlightFilterCriteriaType $flightFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setFlightFilterCriteria(\StructType\FlightFilterCriteriaType $flightFilterCriteria = null)
    {
        $this->FlightFilterCriteria = $flightFilterCriteria;
        return $this;
    }
    /**
     * Get LastModifiedDateTimeFilterCriteria value
     * @return \StructType\DateTimeRangeType|null
     */
    public function getLastModifiedDateTimeFilterCriteria()
    {
        return $this->LastModifiedDateTimeFilterCriteria;
    }
    /**
     * Set LastModifiedDateTimeFilterCriteria value
     * @param \StructType\DateTimeRangeType $lastModifiedDateTimeFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setLastModifiedDateTimeFilterCriteria(\StructType\DateTimeRangeType $lastModifiedDateTimeFilterCriteria = null)
    {
        $this->LastModifiedDateTimeFilterCriteria = $lastModifiedDateTimeFilterCriteria;
        return $this;
    }
    /**
     * Get OrderCancellationDateFilterCriteria value
     * @return \StructType\DateRangeType|null
     */
    public function getOrderCancellationDateFilterCriteria()
    {
        return $this->OrderCancellationDateFilterCriteria;
    }
    /**
     * Set OrderCancellationDateFilterCriteria value
     * @param \StructType\DateRangeType $orderCancellationDateFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setOrderCancellationDateFilterCriteria(\StructType\DateRangeType $orderCancellationDateFilterCriteria = null)
    {
        $this->OrderCancellationDateFilterCriteria = $orderCancellationDateFilterCriteria;
        return $this;
    }
    /**
     * Get PaxFilterCriteria value
     * @return \StructType\PaxFilterCriteriaType|null
     */
    public function getPaxFilterCriteria()
    {
        return $this->PaxFilterCriteria;
    }
    /**
     * Set PaxFilterCriteria value
     * @param \StructType\PaxFilterCriteriaType $paxFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setPaxFilterCriteria(\StructType\PaxFilterCriteriaType $paxFilterCriteria = null)
    {
        $this->PaxFilterCriteria = $paxFilterCriteria;
        return $this;
    }
    /**
     * Get PaxGroupFilterCriteria value
     * @return \StructType\PaxGroupType|null
     */
    public function getPaxGroupFilterCriteria()
    {
        return $this->PaxGroupFilterCriteria;
    }
    /**
     * Set PaxGroupFilterCriteria value
     * @param \StructType\PaxGroupType $paxGroupFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setPaxGroupFilterCriteria(\StructType\PaxGroupType $paxGroupFilterCriteria = null)
    {
        $this->PaxGroupFilterCriteria = $paxGroupFilterCriteria;
        return $this;
    }
    /**
     * Get PaymentFilterCriteria value
     * @return \StructType\PaymentFilterCriteriaType[]|null
     */
    public function getPaymentFilterCriteria()
    {
        return $this->PaymentFilterCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFilterCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFilterCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFilterCriteriaForArrayConstraintsFromSetPaymentFilterCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderSearchFilterCriteriaTypePaymentFilterCriteriaItem) {
            // validation for constraint: itemType
            if (!$orderSearchFilterCriteriaTypePaymentFilterCriteriaItem instanceof \StructType\PaymentFilterCriteriaType) {
                $invalidValues[] = is_object($orderSearchFilterCriteriaTypePaymentFilterCriteriaItem) ? get_class($orderSearchFilterCriteriaTypePaymentFilterCriteriaItem) : sprintf('%s(%s)', gettype($orderSearchFilterCriteriaTypePaymentFilterCriteriaItem), var_export($orderSearchFilterCriteriaTypePaymentFilterCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFilterCriteria property can only contain items of type \StructType\PaymentFilterCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFilterCriteriaType[] $paymentFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setPaymentFilterCriteria(array $paymentFilterCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFilterCriteriaArrayErrorMessage = self::validatePaymentFilterCriteriaForArrayConstraintsFromSetPaymentFilterCriteria($paymentFilterCriteria))) {
            throw new \InvalidArgumentException($paymentFilterCriteriaArrayErrorMessage, __LINE__);
        }
        $this->PaymentFilterCriteria = $paymentFilterCriteria;
        return $this;
    }
    /**
     * Add item to PaymentFilterCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFilterCriteriaType $item
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function addToPaymentFilterCriteria(\StructType\PaymentFilterCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFilterCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFilterCriteria property can only contain items of type \StructType\PaymentFilterCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFilterCriteria[] = $item;
        return $this;
    }
    /**
     * Get ServiceFilterCriteria value
     * @return \StructType\ServiceFilterCriteriaType|null
     */
    public function getServiceFilterCriteria()
    {
        return $this->ServiceFilterCriteria;
    }
    /**
     * Set ServiceFilterCriteria value
     * @param \StructType\ServiceFilterCriteriaType $serviceFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setServiceFilterCriteria(\StructType\ServiceFilterCriteriaType $serviceFilterCriteria = null)
    {
        $this->ServiceFilterCriteria = $serviceFilterCriteria;
        return $this;
    }
    /**
     * Get TicketFilterCriteria value
     * @return \StructType\TicketFilterCriteriaType|null
     */
    public function getTicketFilterCriteria()
    {
        return $this->TicketFilterCriteria;
    }
    /**
     * Set TicketFilterCriteria value
     * @param \StructType\TicketFilterCriteriaType $ticketFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setTicketFilterCriteria(\StructType\TicketFilterCriteriaType $ticketFilterCriteria = null)
    {
        $this->TicketFilterCriteria = $ticketFilterCriteria;
        return $this;
    }
    /**
     * Get TravelDateFilterCriteria value
     * @return \StructType\DateRangeType|null
     */
    public function getTravelDateFilterCriteria()
    {
        return $this->TravelDateFilterCriteria;
    }
    /**
     * Set TravelDateFilterCriteria value
     * @param \StructType\DateRangeType $travelDateFilterCriteria
     * @return \StructType\OrderSearchFilterCriteriaType
     */
    public function setTravelDateFilterCriteria(\StructType\DateRangeType $travelDateFilterCriteria = null)
    {
        $this->TravelDateFilterCriteria = $travelDateFilterCriteria;
        return $this;
    }
}
