<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderSalesInfoNotifRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for message
 * @subpackage Structs
 */
class OrderSalesInfoNotifRequestType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Accounted Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
     * services that are not necessarily Journey based (e.g. subscription services).
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\AccountedOrderType[]
     */
    public $Order;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataListsType
     */
    public $DataLists;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for OrderSalesInfoNotifRequestType
     * @uses OrderSalesInfoNotifRequestType::setOrder()
     * @uses OrderSalesInfoNotifRequestType::setCommission()
     * @uses OrderSalesInfoNotifRequestType::setDataLists()
     * @uses OrderSalesInfoNotifRequestType::setMetadata()
     * @uses OrderSalesInfoNotifRequestType::setResponseParameters()
     * @uses OrderSalesInfoNotifRequestType::setWarning()
     * @param \StructType\AccountedOrderType[] $order
     * @param \StructType\CommissionType[] $commission
     * @param \StructType\DataListsType $dataLists
     * @param \StructType\MetadataType $metadata
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(array $order = array(), array $commission = array(), \StructType\DataListsType $dataLists = null, \StructType\MetadataType $metadata = null, \StructType\ResponseParametersRequestType $responseParameters = null, array $warning = array())
    {
        $this
            ->setOrder($order)
            ->setCommission($commission)
            ->setDataLists($dataLists)
            ->setMetadata($metadata)
            ->setResponseParameters($responseParameters)
            ->setWarning($warning);
    }
    /**
     * Get Order value
     * @return \StructType\AccountedOrderType[]
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderSalesInfoNotifRequestTypeOrderItem) {
            // validation for constraint: itemType
            if (!$orderSalesInfoNotifRequestTypeOrderItem instanceof \StructType\AccountedOrderType) {
                $invalidValues[] = is_object($orderSalesInfoNotifRequestTypeOrderItem) ? get_class($orderSalesInfoNotifRequestTypeOrderItem) : sprintf('%s(%s)', gettype($orderSalesInfoNotifRequestTypeOrderItem), var_export($orderSalesInfoNotifRequestTypeOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order property can only contain items of type \StructType\AccountedOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedOrderType[] $order
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedOrderType $item
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function addToOrder(\StructType\AccountedOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountedOrderType) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of type \StructType\AccountedOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderSalesInfoNotifRequestTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$orderSalesInfoNotifRequestTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($orderSalesInfoNotifRequestTypeCommissionItem) ? get_class($orderSalesInfoNotifRequestTypeCommissionItem) : sprintf('%s(%s)', gettype($orderSalesInfoNotifRequestTypeCommissionItem), var_export($orderSalesInfoNotifRequestTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\DataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\DataListsType $dataLists
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function setDataLists(\StructType\DataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderSalesInfoNotifRequestTypeWarningItem) {
            // validation for constraint: itemType
            if (!$orderSalesInfoNotifRequestTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($orderSalesInfoNotifRequestTypeWarningItem) ? get_class($orderSalesInfoNotifRequestTypeWarningItem) : sprintf('%s(%s)', gettype($orderSalesInfoNotifRequestTypeWarningItem), var_export($orderSalesInfoNotifRequestTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\OrderSalesInfoNotifRequestType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
