<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderRulesResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Order Rules message
 * @subpackage Structs
 */
class OrderRulesResponseType extends AbstractStructBase
{
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - documentation: Message policy information, including PCI, PII information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PolicyType
     */
    public $Policy;
    /**
     * The Processing
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersResponseType
     */
    public $Processing;
    /**
     * The Rules
     * Meta information extracted from the WSDL
     * - documentation: A rules type
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RulesType[]
     */
    public $Rules;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningType
     */
    public $Warning;
    /**
     * Constructor method for OrderRulesResponseType
     * @uses OrderRulesResponseType::setMetadata()
     * @uses OrderRulesResponseType::setPolicy()
     * @uses OrderRulesResponseType::setProcessing()
     * @uses OrderRulesResponseType::setRules()
     * @uses OrderRulesResponseType::setWarning()
     * @param \StructType\MetadataType $metadata
     * @param \StructType\PolicyType $policy
     * @param \StructType\ResponseParametersResponseType $processing
     * @param \StructType\RulesType[] $rules
     * @param \StructType\WarningType $warning
     */
    public function __construct(\StructType\MetadataType $metadata = null, \StructType\PolicyType $policy = null, \StructType\ResponseParametersResponseType $processing = null, array $rules = array(), \StructType\WarningType $warning = null)
    {
        $this
            ->setMetadata($metadata)
            ->setPolicy($policy)
            ->setProcessing($processing)
            ->setRules($rules)
            ->setWarning($warning);
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\OrderRulesResponseType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\PolicyType|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * Set Policy value
     * @param \StructType\PolicyType $policy
     * @return \StructType\OrderRulesResponseType
     */
    public function setPolicy(\StructType\PolicyType $policy = null)
    {
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Get Processing value
     * @return \StructType\ResponseParametersResponseType|null
     */
    public function getProcessing()
    {
        return $this->Processing;
    }
    /**
     * Set Processing value
     * @param \StructType\ResponseParametersResponseType $processing
     * @return \StructType\OrderRulesResponseType
     */
    public function setProcessing(\StructType\ResponseParametersResponseType $processing = null)
    {
        $this->Processing = $processing;
        return $this;
    }
    /**
     * Get Rules value
     * @return \StructType\RulesType[]|null
     */
    public function getRules()
    {
        return $this->Rules;
    }
    /**
     * This method is responsible for validating the values passed to the setRules method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRules method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRulesForArrayConstraintsFromSetRules(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderRulesResponseTypeRulesItem) {
            // validation for constraint: itemType
            if (!$orderRulesResponseTypeRulesItem instanceof \StructType\RulesType) {
                $invalidValues[] = is_object($orderRulesResponseTypeRulesItem) ? get_class($orderRulesResponseTypeRulesItem) : sprintf('%s(%s)', gettype($orderRulesResponseTypeRulesItem), var_export($orderRulesResponseTypeRulesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rules property can only contain items of type \StructType\RulesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rules value
     * @throws \InvalidArgumentException
     * @param \StructType\RulesType[] $rules
     * @return \StructType\OrderRulesResponseType
     */
    public function setRules(array $rules = array())
    {
        // validation for constraint: array
        if ('' !== ($rulesArrayErrorMessage = self::validateRulesForArrayConstraintsFromSetRules($rules))) {
            throw new \InvalidArgumentException($rulesArrayErrorMessage, __LINE__);
        }
        $this->Rules = $rules;
        return $this;
    }
    /**
     * Add item to Rules value
     * @throws \InvalidArgumentException
     * @param \StructType\RulesType $item
     * @return \StructType\OrderRulesResponseType
     */
    public function addToRules(\StructType\RulesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RulesType) {
            throw new \InvalidArgumentException(sprintf('The Rules property can only contain items of type \StructType\RulesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Rules[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * Set Warning value
     * @param \StructType\WarningType $warning
     * @return \StructType\OrderRulesResponseType
     */
    public function setWarning(\StructType\WarningType $warning = null)
    {
        $this->Warning = $warning;
        return $this;
    }
}
