<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderRulesRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Order Rules message
 * @subpackage Structs
 */
class OrderRulesRequestType extends AbstractStructBase
{
    /**
     * The RulesCoreRequest
     * Meta information extracted from the WSDL
     * - documentation: Rules Core Request
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RulesCoreRequestType
     */
    public $RulesCoreRequest;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - documentation: Message policy information, including PCI, PII information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PolicyType[]
     */
    public $Policy;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for OrderRulesRequestType
     * @uses OrderRulesRequestType::setRulesCoreRequest()
     * @uses OrderRulesRequestType::setMetadata()
     * @uses OrderRulesRequestType::setPolicy()
     * @uses OrderRulesRequestType::setResponseParameters()
     * @param \StructType\RulesCoreRequestType $rulesCoreRequest
     * @param \StructType\MetadataType $metadata
     * @param \StructType\PolicyType[] $policy
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct(\StructType\RulesCoreRequestType $rulesCoreRequest = null, \StructType\MetadataType $metadata = null, array $policy = array(), \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setRulesCoreRequest($rulesCoreRequest)
            ->setMetadata($metadata)
            ->setPolicy($policy)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get RulesCoreRequest value
     * @return \StructType\RulesCoreRequestType
     */
    public function getRulesCoreRequest()
    {
        return $this->RulesCoreRequest;
    }
    /**
     * Set RulesCoreRequest value
     * @param \StructType\RulesCoreRequestType $rulesCoreRequest
     * @return \StructType\OrderRulesRequestType
     */
    public function setRulesCoreRequest(\StructType\RulesCoreRequestType $rulesCoreRequest = null)
    {
        $this->RulesCoreRequest = $rulesCoreRequest;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\OrderRulesRequestType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\PolicyType[]|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyForArrayConstraintsFromSetPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderRulesRequestTypePolicyItem) {
            // validation for constraint: itemType
            if (!$orderRulesRequestTypePolicyItem instanceof \StructType\PolicyType) {
                $invalidValues[] = is_object($orderRulesRequestTypePolicyItem) ? get_class($orderRulesRequestTypePolicyItem) : sprintf('%s(%s)', gettype($orderRulesRequestTypePolicyItem), var_export($orderRulesRequestTypePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType[] $policy
     * @return \StructType\OrderRulesRequestType
     */
    public function setPolicy(array $policy = array())
    {
        // validation for constraint: array
        if ('' !== ($policyArrayErrorMessage = self::validatePolicyForArrayConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyArrayErrorMessage, __LINE__);
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Add item to Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType $item
     * @return \StructType\OrderRulesRequestType
     */
    public function addToPolicy(\StructType\PolicyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyType) {
            throw new \InvalidArgumentException(sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Policy[] = $item;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\OrderRulesRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
