<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderRetrieveRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Order Retrieve message
 * @subpackage Structs
 */
class OrderRetrieveRequestType extends AbstractStructBase
{
    /**
     * The OrderValidationFilterCriteria
     * Meta information extracted from the WSDL
     * - documentation: Order Validation filter criteria.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderValidationFilterCriteriaType
     */
    public $OrderValidationFilterCriteria;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for OrderRetrieveRequestType
     * @uses OrderRetrieveRequestType::setOrderValidationFilterCriteria()
     * @uses OrderRetrieveRequestType::setResponseParameters()
     * @param \StructType\OrderValidationFilterCriteriaType $orderValidationFilterCriteria
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct(\StructType\OrderValidationFilterCriteriaType $orderValidationFilterCriteria = null, \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setOrderValidationFilterCriteria($orderValidationFilterCriteria)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get OrderValidationFilterCriteria value
     * @return \StructType\OrderValidationFilterCriteriaType
     */
    public function getOrderValidationFilterCriteria()
    {
        return $this->OrderValidationFilterCriteria;
    }
    /**
     * Set OrderValidationFilterCriteria value
     * @param \StructType\OrderValidationFilterCriteriaType $orderValidationFilterCriteria
     * @return \StructType\OrderRetrieveRequestType
     */
    public function setOrderValidationFilterCriteria(\StructType\OrderValidationFilterCriteriaType $orderValidationFilterCriteria = null)
    {
        $this->OrderValidationFilterCriteria = $orderValidationFilterCriteria;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\OrderRetrieveRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
