<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderPenaltyInfoListType StructType
 * Meta information extracted from the WSDL
 * - documentation: list of Order Penalty Information.
 * @subpackage Structs
 */
class OrderPenaltyInfoListType extends AbstractStructBase
{
    /**
     * The PenaltyInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to a penalty applied to an OrderItem following a servicing operation.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OrderPenaltyInfoType[]
     */
    public $PenaltyInfo;
    /**
     * Constructor method for OrderPenaltyInfoListType
     * @uses OrderPenaltyInfoListType::setPenaltyInfo()
     * @param \StructType\OrderPenaltyInfoType[] $penaltyInfo
     */
    public function __construct(array $penaltyInfo = array())
    {
        $this
            ->setPenaltyInfo($penaltyInfo);
    }
    /**
     * Get PenaltyInfo value
     * @return \StructType\OrderPenaltyInfoType[]
     */
    public function getPenaltyInfo()
    {
        return $this->PenaltyInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyInfoForArrayConstraintsFromSetPenaltyInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderPenaltyInfoListTypePenaltyInfoItem) {
            // validation for constraint: itemType
            if (!$orderPenaltyInfoListTypePenaltyInfoItem instanceof \StructType\OrderPenaltyInfoType) {
                $invalidValues[] = is_object($orderPenaltyInfoListTypePenaltyInfoItem) ? get_class($orderPenaltyInfoListTypePenaltyInfoItem) : sprintf('%s(%s)', gettype($orderPenaltyInfoListTypePenaltyInfoItem), var_export($orderPenaltyInfoListTypePenaltyInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyInfo property can only contain items of type \StructType\OrderPenaltyInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderPenaltyInfoType[] $penaltyInfo
     * @return \StructType\OrderPenaltyInfoListType
     */
    public function setPenaltyInfo(array $penaltyInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyInfoArrayErrorMessage = self::validatePenaltyInfoForArrayConstraintsFromSetPenaltyInfo($penaltyInfo))) {
            throw new \InvalidArgumentException($penaltyInfoArrayErrorMessage, __LINE__);
        }
        $this->PenaltyInfo = $penaltyInfo;
        return $this;
    }
    /**
     * Add item to PenaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderPenaltyInfoType $item
     * @return \StructType\OrderPenaltyInfoListType
     */
    public function addToPenaltyInfo(\StructType\OrderPenaltyInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderPenaltyInfoType) {
            throw new \InvalidArgumentException(sprintf('The PenaltyInfo property can only contain items of type \StructType\OrderPenaltyInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyInfo[] = $item;
        return $this;
    }
}
