<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemKeyType StructType
 * Meta information extracted from the WSDL
 * - documentation: An Order key individually priced item within an Order key Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
 * @subpackage Structs
 */
class OrderItemKeyType extends AbstractStructBase
{
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemRefID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Service Key specialization of an instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can
     * be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceKeyType[]
     */
    public $Service;
    /**
     * Constructor method for OrderItemKeyType
     * @uses OrderItemKeyType::setOrderItemRefID()
     * @uses OrderItemKeyType::setOwnerCode()
     * @uses OrderItemKeyType::setService()
     * @param string $orderItemRefID
     * @param string $ownerCode
     * @param \StructType\ServiceKeyType[] $service
     */
    public function __construct($orderItemRefID = null, $ownerCode = null, array $service = array())
    {
        $this
            ->setOrderItemRefID($orderItemRefID)
            ->setOwnerCode($ownerCode)
            ->setService($service);
    }
    /**
     * Get OrderItemRefID value
     * @return string
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * Set OrderItemRefID value
     * @param string $orderItemRefID
     * @return \StructType\OrderItemKeyType
     */
    public function setOrderItemRefID($orderItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemRefID) && !is_string($orderItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemRefID, true), gettype($orderItemRefID)), __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\OrderItemKeyType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ServiceKeyType[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderItemKeyTypeServiceItem) {
            // validation for constraint: itemType
            if (!$orderItemKeyTypeServiceItem instanceof \StructType\ServiceKeyType) {
                $invalidValues[] = is_object($orderItemKeyTypeServiceItem) ? get_class($orderItemKeyTypeServiceItem) : sprintf('%s(%s)', gettype($orderItemKeyTypeServiceItem), var_export($orderItemKeyTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\ServiceKeyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceKeyType[] $service
     * @return \StructType\OrderItemKeyType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceKeyType $item
     * @return \StructType\OrderItemKeyType
     */
    public function addToService(\StructType\ServiceKeyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceKeyType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\ServiceKeyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
}
