<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderChangeUpdatePaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specialisation for Order Change of update passenger. Function to Add, Remove or Update the Passenger Details. Providing the New and Previous values together implies an Update.
 * @subpackage Structs
 */
class OrderChangeUpdatePaxType extends AbstractStructBase
{
    /**
     * The Current
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxRefType
     */
    public $Current;
    /**
     * The New
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxRefType
     */
    public $New;
    /**
     * The PaxSharingPref
     * Meta information extracted from the WSDL
     * - documentation: This will be used to identify a Passenger's sharing preference. The passenger can request that his/her information is not shared with other passengers in the same order. Additionally the passenger can be in a requested selected group
     * of passengers whom wish to not share with the remaining passengers in the booking . E.g could be a group of a family members in a larger group booking.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSharingPrefType
     */
    public $PaxSharingPref;
    /**
     * Constructor method for OrderChangeUpdatePaxType
     * @uses OrderChangeUpdatePaxType::setCurrent()
     * @uses OrderChangeUpdatePaxType::setNew()
     * @uses OrderChangeUpdatePaxType::setPaxSharingPref()
     * @param \StructType\PaxRefType $current
     * @param \StructType\PaxRefType $new
     * @param \StructType\PaxSharingPrefType $paxSharingPref
     */
    public function __construct(\StructType\PaxRefType $current = null, \StructType\PaxRefType $new = null, \StructType\PaxSharingPrefType $paxSharingPref = null)
    {
        $this
            ->setCurrent($current)
            ->setNew($new)
            ->setPaxSharingPref($paxSharingPref);
    }
    /**
     * Get Current value
     * @return \StructType\PaxRefType|null
     */
    public function getCurrent()
    {
        return $this->Current;
    }
    /**
     * Set Current value
     * @param \StructType\PaxRefType $current
     * @return \StructType\OrderChangeUpdatePaxType
     */
    public function setCurrent(\StructType\PaxRefType $current = null)
    {
        $this->Current = $current;
        return $this;
    }
    /**
     * Get New value
     * @return \StructType\PaxRefType|null
     */
    public function getNew()
    {
        return $this->New;
    }
    /**
     * Set New value
     * @param \StructType\PaxRefType $new
     * @return \StructType\OrderChangeUpdatePaxType
     */
    public function setNew(\StructType\PaxRefType $new = null)
    {
        $this->New = $new;
        return $this;
    }
    /**
     * Get PaxSharingPref value
     * @return \StructType\PaxSharingPrefType|null
     */
    public function getPaxSharingPref()
    {
        return $this->PaxSharingPref;
    }
    /**
     * Set PaxSharingPref value
     * @param \StructType\PaxSharingPrefType $paxSharingPref
     * @return \StructType\OrderChangeUpdatePaxType
     */
    public function setPaxSharingPref(\StructType\PaxSharingPrefType $paxSharingPref = null)
    {
        $this->PaxSharingPref = $paxSharingPref;
        return $this;
    }
}
