<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionalOriginDestListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Origin Destination data list definition.
 * @subpackage Structs
 */
class OptionalOriginDestListType extends AbstractStructBase
{
    /**
     * The OriginDest
     * Meta information extracted from the WSDL
     * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OptionalOriginDestType[]
     */
    public $OriginDest;
    /**
     * Constructor method for OptionalOriginDestListType
     * @uses OptionalOriginDestListType::setOriginDest()
     * @param \StructType\OptionalOriginDestType[] $originDest
     */
    public function __construct(array $originDest = array())
    {
        $this
            ->setOriginDest($originDest);
    }
    /**
     * Get OriginDest value
     * @return \StructType\OptionalOriginDestType[]
     */
    public function getOriginDest()
    {
        return $this->OriginDest;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginDest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginDestForArrayConstraintsFromSetOriginDest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $optionalOriginDestListTypeOriginDestItem) {
            // validation for constraint: itemType
            if (!$optionalOriginDestListTypeOriginDestItem instanceof \StructType\OptionalOriginDestType) {
                $invalidValues[] = is_object($optionalOriginDestListTypeOriginDestItem) ? get_class($optionalOriginDestListTypeOriginDestItem) : sprintf('%s(%s)', gettype($optionalOriginDestListTypeOriginDestItem), var_export($optionalOriginDestListTypeOriginDestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginDest property can only contain items of type \StructType\OptionalOriginDestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginDest value
     * @throws \InvalidArgumentException
     * @param \StructType\OptionalOriginDestType[] $originDest
     * @return \StructType\OptionalOriginDestListType
     */
    public function setOriginDest(array $originDest = array())
    {
        // validation for constraint: array
        if ('' !== ($originDestArrayErrorMessage = self::validateOriginDestForArrayConstraintsFromSetOriginDest($originDest))) {
            throw new \InvalidArgumentException($originDestArrayErrorMessage, __LINE__);
        }
        $this->OriginDest = $originDest;
        return $this;
    }
    /**
     * Add item to OriginDest value
     * @throws \InvalidArgumentException
     * @param \StructType\OptionalOriginDestType $item
     * @return \StructType\OptionalOriginDestListType
     */
    public function addToOriginDest(\StructType\OptionalOriginDestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OptionalOriginDestType) {
            throw new \InvalidArgumentException(sprintf('The OriginDest property can only contain items of type \StructType\OptionalOriginDestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginDest[] = $item;
        return $this;
    }
}
